//                                               -*- C++ -*-
/**
 *  @file  ComputedNumericalMathGradientImplementationFactory.hxx
 *  @brief The class ComputedNumericalMathGradientImplementationFactory creates ComputedNumericalMathGradientImplementation from external codes
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: ComputedNumericalMathGradientImplementationFactory.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_COMPUTEDNUMERICALMATHGRADIENTIMPLEMENTATIONFACTORY_HXX
#define OPENTURNS_COMPUTEDNUMERICALMATHGRADIENTIMPLEMENTATIONFACTORY_HXX

#include <iostream>              // for std::ostream
#include "OTprivate.hxx"
#include "Pointer.hxx"
#include "Exception.hxx"
#include "ComputedNumericalMathGradientImplementation.hxx"
#include "NumericalMathGradientImplementationFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      /**
       * @class ComputedNumericalMathGradientImplementationFactory
       *
       * ComputedNumericalMathGradientImplementationFactory creates ComputedNumericalMathGradientImplementation from external codes
       */

      class ComputedNumericalMathGradientImplementationFactory
	: public NumericalMathGradientImplementationFactory
      {
	CLASSNAME;
      public:

	/* Some typedefs to ease reading */
	typedef Common::Pointer<ComputedNumericalMathGradientImplementationFactory> Instance;
	typedef NumericalMathGradientImplementationFactory::Implementation Implementation;
	typedef Common::InvalidArgumentException InvalidArgumentException;

	/** The accessor to the Singleton element */
	static Instance getInstance();



      public:

	/** String converter */
	virtual String __repr__() const;


	/** Object builder */
	virtual NumericalMathGradientImplementation * buildObject(const String & functionName) const;


      protected:

      private:

	/** The unique instance of the Singleton model */
	static Instance P_instance_;

	/** Default constructor */
	ComputedNumericalMathGradientImplementationFactory();



      }

      ; /* class ComputedNumericalMathGradientImplementationFactory */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COMPUTEDNUMERICALMATHGRADIENTIMPLEMENTATIONFACTORY_HXX */
