//                                               -*- C++ -*-
/**
 *  @file  CenteredFiniteDifferenceGradient.hxx
 *  @brief Class for the creation of a numerical math gradient implementation
 *         form a numerical math evaluation implementation by using centered
 *         finite difference formula.
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: CenteredFiniteDifferenceGradient.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_CENTEREDFINITEDIFFERENCEGRADIENT_HXX
#define OPENTURNS_CENTEREDFINITEDIFFERENCEGRADIENT_HXX

#define OPENTURNS_CENTEREDFINITEDIFFERENCEGRADIENT_HXX

#include "NumericalMathGradientImplementation.hxx"
#include "NumericalMathEvaluationImplementation.hxx"
#include "Exception.hxx"
#include "NumericalPoint.hxx"
#include "Matrix.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Diff {


      /**
       * @class CenteredFiniteDifferenceGradient
       *
       * This class is for the creation of a numerical math gradient implementation
       * form a numerical math evaluation implementation by using centered
       * finite difference formula
       */
      class CenteredFiniteDifferenceGradient
        : public Func::NumericalMathGradientImplementation
      {
        CLASSNAME;
      public:

        static const NumericalScalar DefaultEpsilon;

        typedef Func::NumericalMathGradientImplementation::Description              Description;
        typedef Func::NumericalMathGradientImplementation::NumericalPoint           NumericalPoint;
        typedef Func::NumericalMathGradientImplementation::Matrix                   Matrix;
        typedef Func::NumericalMathGradientImplementation::Tensor                   Tensor;
        typedef Func::NumericalMathGradientImplementation::InvalidArgumentException InvalidArgumentException;
        typedef Func::NumericalMathGradientImplementation::InternalException        InternalException;
        typedef Func::NumericalMathGradientImplementation::StorageManager           StorageManager;
        typedef Common::InvalidDimensionException                                   InvalidDimensionException;
        typedef Common::Pointer<Func::NumericalMathEvaluationImplementation>          EvaluationImplementation;

        /** Default constructor */
        CenteredFiniteDifferenceGradient();

        /** Parameter constructor */
        CenteredFiniteDifferenceGradient(const NumericalPoint & epsilon,
                                         const EvaluationImplementation & p_evaluation)
          throw(InvalidDimensionException);

        /** Second parameter constructor */
        CenteredFiniteDifferenceGradient(const NumericalScalar epsilon,
                                         const EvaluationImplementation & p_evaluation)
          throw(InvalidDimensionException);

        /** Virtual constructor */
        virtual CenteredFiniteDifferenceGradient * clone() const;

        /** Comparison operator */
        Bool operator ==(const CenteredFiniteDifferenceGradient & other) const;

        /** String converter */
        virtual String __repr__() const;



        /* Here is the interface that all derived class must implement */

        /** Gradient () */
        virtual Matrix gradient(const NumericalPoint & in) const
          throw(InvalidArgumentException, InternalException);

        /** Accessor for input point dimension */
        virtual UnsignedLong getInputNumericalPointDimension() const
          throw(InternalException);

        /** Accessor for output point dimension */
        virtual UnsignedLong getOutputNumericalPointDimension() const
          throw(InternalException);

        /** Accessor for the epsilon */
        NumericalPoint getEpsilon() const;

        /** Accessor for the evaluation */
        EvaluationImplementation getEvaluation() const;

        /** Method save() stores the object through the StorageManager */
        void save(const StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(const StorageManager::Advocate & adv);

      protected:


      private:
        NumericalPoint epsilon_;
        EvaluationImplementation p_evaluation_;

      }; /* class CenteredFiniteDifferenceGradient */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_CENTEREDFINITEDIFFERENCEGRADIENT_HXX */
