\name{computeTestTwoSampleChiSquared}
\alias{computeTestTwoSampleChiSquared}
\title{Compute the 2-sample chi squared test.}
\description{
This ROT function, called from a Test C++ object, is given two samples,
and optionnaly a test level. 
It then computes the result of a X test against the null hypothesis 
that the samples have the same underlying distribution and returns a
list containing the result, statistic and test p-value.
}
\usage{
computeTestTwoSampleChiSquared(numericalSample1,  numericalSample2, testLevel = 0.95)
}
\arguments{
  \item{numericalSample1}{The first sample to be tested (discrete numeric vector)}
  \item{numericalSample2}{The second sample to be tested (discrete numeric vector)}
  \item{testLevel}{the test level. (scalar in [0:1])}
}
\value{
 A list is returned, containing :
  \item{testResult}{The result. 1 means H0 is not rejected. (scalar)}
  \item{threshold}{The threshold applied to the p-value when deciding the outcome of the test.}
  \item{pValue}{The test p-value. (scalar)}
}
\author{Pierre-Matthieu Pair, Softia for EDF.}
\examples{
?chisq.test
}
\keyword{multivariate}

