#! /usr/bin/env python

from openturns import *
from math import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :


  #########################################################################################################
  # Physical model
  #########################################################################################################
  
  inputFunction = Description(2)
  inputFunction[0] = "u1"
  inputFunction[1] = "u2"
  
  outputFunction = Description(1)
  outputFunction[0] = "G"
  
  formulas = Description(outputFunction.getSize())
  formulas[0] = "3.0 - u1*u2"
  
  EtatLimite = NumericalMathFunction(inputFunction, outputFunction, formulas)
  
  dim=EtatLimite.getInputNumericalPointDimension()
  print dim
  
  #########################################################################################################
  # Probabilistic model
  #########################################################################################################
  
  mean = NumericalPoint(dim, 0.0)
  mean[0] = 0.0
  mean[1] = 0.0
  
  sigma = NumericalPoint(dim, 0.0)
  sigma[0] = 1.0
  sigma[1] = 1.0
  
  R = CorrelationMatrix(dim)
  myDistribution = Normal(mean, sigma, R)
  
  #start=myDistribution.getMean()
  start=NumericalPoint(dim, 1.0)
  
  Covariance= myDistribution.getCovariance()
  
  #########################################################################################################
  # ELimit state
  #########################################################################################################
  
  vect = RandomVector(myDistribution)
  
  output = RandomVector(EtatLimite, vect)
  
  myEvent = Event(output, ComparisonOperator(Less()), 0.0)
  
  #########################################################################################################
  # Calculs
  #########################################################################################################
  
  #########################################################################################################
  # FORM/SORM Cobyla
  myCobyla = Cobyla()
  myCobyla.setSpecificParameters(CobylaSpecificParameters())
  myCobyla.setMaximumIterationsNumber(100)
  myCobyla.setMaximumAbsoluteError(1.0e-10)
  myCobyla.setMaximumRelativeError(1.0e-10)
  myCobyla.setMaximumResidualError(1.0e-10)
  myCobyla.setMaximumConstraintError(1.0e-10)
  
  myAlgoC = FORM(NearestPointAlgorithm(myCobyla), myEvent, start)
  myAlgoC2 = SORM(NearestPointAlgorithm(myCobyla), myEvent, start)
  
  myAlgoC.run()
  myAlgoC2.run()
  
  resultC = FORMResult(myAlgoC.getResult())
  resultC2 = SORMResult(myAlgoC2.getResult())
  
  #########################################################################################################
  # FORM/SORM Abdo Rackwitz
  myAbdoRackwitz = AbdoRackwitz()
  myAbdoRackwitz.setSpecificParameters(AbdoRackwitzSpecificParameters())
  myAbdoRackwitz.setMaximumIterationsNumber(100)
  myAbdoRackwitz.setMaximumAbsoluteError(1.0e-10)
  myAbdoRackwitz.setMaximumRelativeError(1.0e-10)
  myAbdoRackwitz.setMaximumResidualError(1.0e-10)
  myAbdoRackwitz.setMaximumConstraintError(1.0e-10)
  
  myAlgoAR = FORM(NearestPointAlgorithm(myAbdoRackwitz), myEvent, start)
  myAlgoAR2 = SORM(NearestPointAlgorithm(myAbdoRackwitz), myEvent, start)
  
  myAlgoAR.run()
  myAlgoAR2.run()
  
  resultAR = FORMResult(myAlgoAR.getResult())
  resultAR2 = SORMResult(myAlgoAR2.getResult())
  
  #########################################################################################################
  # Monte Carlo
  CoV_MC=0.1
  myMC = MonteCarlo(myEvent)
  myMC.setMaximumOuterSampling(8000)
  myMC.setBlockSize(1)
  myMC.setMaximumCoefficientOfVariation(CoV_MC)
  myMC.run()
  
  #########################################################################################################
  # LHS
  CoV_LHS=0.1
  myLHS = LHS(myEvent)
  myLHS.setMaximumOuterSampling(8000)
  myLHS.setBlockSize(1)
  myLHS.setMaximumCoefficientOfVariation(CoV_LHS)
  myLHS.run()
  
  
  #########################################################################################################
  # Resultats
  #########################################################################################################
  
  #########################################################################################################
  # FORM/SORM Cobyla
  PfC = resultC.getEventProbability()
  Beta_generalizedC = resultC.getGeneralisedReliabilityIndex()
  u_starC = resultC.getStandardSpaceDesignPoint()
  x_starC = resultC.getPhysicalSpaceDesignPoint()
  PtC = resultC.getIsStandardPointOriginInFailureSpace() and "true" or "false"
  gammaC = resultC.getImportanceFactors()
  beta_hasoferC = resultC.getHasoferReliabilityIndex()
  SensitivityC = resultC.getEventProbabilitySensitivity()
  
  PFBreitC2 = resultC2.getEventProbabilityBreitung()
  BetaBreitC2 = resultC2.getGeneralisedReliabilityIndexBreitung()
  PFHBC2=resultC2.getEventProbabilityHohenBichler()
  BetaHBC2=resultC2.getGeneralisedReliabilityIndexHohenBichler()
  PFTvedtC2 = resultC2.getEventProbabilityTvedt()
  BetaTvedtC2 = resultC2.getGeneralisedReliabilityIndexTvedt()
  CurvC2 = resultC2.getSortedCurvatures()
  u_starC2 = resultC2.getStandardSpaceDesignPoint()
  x_starC2 = resultC2.getPhysicalSpaceDesignPoint()
  PtC2 = resultC2.getIsStandardPointOriginInFailureSpace() and "true" or "false"
  gammaC2 = resultC2.getImportanceFactors()
  beta_hasoferC2 = resultC2.getHasoferReliabilityIndex()
  
  #########################################################################################################
  # FORM/SORM Abdo Rackwitz
  PfAR = resultAR.getEventProbability()
  Beta_generalizedAR = resultAR.getGeneralisedReliabilityIndex()
  u_starAR = resultAR.getStandardSpaceDesignPoint()
  x_starAR = resultAR.getPhysicalSpaceDesignPoint()
  PtAR = resultAR.getIsStandardPointOriginInFailureSpace() and "true" or "false"
  gammaAR = resultAR.getImportanceFactors()
  beta_hasoferAR = resultAR.getHasoferReliabilityIndex()
  SensitivityAR = resultAR.getEventProbabilitySensitivity()
  
  PFBreitAR2 = resultAR2.getEventProbabilityBreitung()
  BetaBreitAR2 = resultAR2.getGeneralisedReliabilityIndexBreitung()
  PFHBAR2=resultAR2.getEventProbabilityHohenBichler()
  BetaHBAR2=resultAR2.getGeneralisedReliabilityIndexHohenBichler()
  PFTvedtAR2 = resultAR2.getEventProbabilityTvedt()
  BetaTvedtAR2 = resultAR2.getGeneralisedReliabilityIndexTvedt()
  CurvAR2 = resultAR2.getSortedCurvatures()
  u_starAR2 = resultAR2.getStandardSpaceDesignPoint()
  x_starAR2 = resultAR2.getPhysicalSpaceDesignPoint()
  PtAR2 = resultAR2.getIsStandardPointOriginInFailureSpace() and "true" or "false"
  gammaAR2 = resultAR2.getImportanceFactors()
  beta_hasoferAR2 = resultAR2.getHasoferReliabilityIndex()
  
  #########################################################################################################
  # Monte Carlo
  ResultMC = myMC.getResult()
  PFMC = ResultMC.getProbabilityEstimate()
  CVMC = ResultMC.getCoefficientOfVariation()
  Variance_PF_MC = ResultMC.getVarianceEstimate()
  length90MC = ResultMC.getConfidenceLength(0.90)
  
  #########################################################################################################
  # LHS
  ResultLHS = myLHS.getResult()
  PFLHS = ResultLHS.getProbabilityEstimate()
  CVLHS = ResultLHS.getCoefficientOfVariation()
  Variance_PF_LHS = ResultLHS.getVarianceEstimate()
  length90LHS = ResultLHS.getConfidenceLength(0.90)
  
  #########################################################################################################
  # Printting
  #########################################################################################################
  print  ""
  print  ""
  print  "************************************************************************************************"
  print  "***************************************** FORM  COBYLA *****************************************"
  print  "************************************************************************************************"
  print  "event probability =", PfC
  print  "generalized reliability index =" , Beta_generalizedC
  print  "************************************************************************************************"
  for i in range(u_starC.getDimension()) :
    print "standard space design point =" , u_starC[i]
  print  "************************************************************************************************"
  for i in range(x_starC.getDimension()) :
    print "physical space design point =" , x_starC[i]
  print  "************************************************************************************************"
  print "is standard point origin in failure space? " , PtC
  print  "************************************************************************************************"
  for i in range(gammaC.getDimension()) :
    print "importance factors =" , gammaC[i]
  print  "************************************************************************************************"
  print  "Hasofer reliability index =" , beta_hasoferC
  print  "************************************************************************************************"
  for i in range(SensitivityC.getSize()) :
    for j in range(SensitivityC[i].getDimension()) :
      print  "Pf sensitivity =", SensitivityC[i][j]
  print  "************************************************************************************************"
  print  ""
  print  "************************************************************************************************"
  print  "************************************** FORM ABDO RACKWITZ **************************************"
  print  "************************************************************************************************"
  print  "event probability =", PfAR
  print  "generalized reliability index =" , Beta_generalizedAR
  print  "************************************************************************************************"
  for i in range(u_starAR.getDimension()) :
    print "standard space design point =" , u_starAR[i]
  print  "************************************************************************************************"
  for i in range(x_starAR.getDimension()) :
    print "physical space design point =" , x_starAR[i]
  print  "************************************************************************************************"
  print "is standard point origin in failure space? " , PtAR
  print  "************************************************************************************************"
  for i in range(gammaAR.getDimension()) :
    print "importance factors =" , gammaAR[i]
  print  "************************************************************************************************"
  print  "Hasofer reliability index =" , beta_hasoferAR
  print  "************************************************************************************************"
  for i in range(SensitivityAR.getSize()) :
    for j in range(SensitivityAR[i].getDimension()) :
      print  "Pf sensitivity =", SensitivityAR[i][j]
  print  "************************************************************************************************"
  print  ""
  print  "************************************************************************************************"
  print  "***************************************** SORM  COBYLA *****************************************"
  print  "************************************************************************************************"
  print  "Breitung event probability =", PFBreitC2
  print  "Breitung generalized reliability index =", BetaBreitC2
  print  "HohenBichler event probability =", PFHBC2
  print  "HohenBichler generalized reliability index =", BetaHBC2
  print  "Tvedt event probability =", PFTvedtC2
  print  "Tvedt generalized reliability index =", BetaTvedtC2
  print  "************************************************************************************************"
  for i in range(CurvC2.getDimension()) :
    print "sorted curvatures =" , CurvC2[i]
  print  "************************************************************************************************"
  for i in range(u_starC2.getDimension()) :
    print "standard space design point =" , u_starC2[i]
  print  "************************************************************************************************"
  for i in range(x_starC2.getDimension()) :
    print "physical space design point =" , x_starC2[i]
  print  "************************************************************************************************"
  print  "************************************************************************************************"
  print "is standard point origin in failure space? " , PtC2
  print  "************************************************************************************************"
  for i in range(gammaC2.getDimension()) :
    print "importance factors =" , gammaC2[i]
  print  "************************************************************************************************"
  print  "Hasofer reliability index =" , beta_hasoferC2
  print  "************************************************************************************************"
  print  ""
  print  "************************************************************************************************"
  print  "************************************** SORM ABDO RACKWITZ **************************************"
  print  "************************************************************************************************"
  print  "Breitung event probability =", PFBreitAR2
  print  "Breitung generalized reliability index =", BetaBreitAR2
  print  "HohenBichler event probability =", PFHBAR2
  print  "HohenBichler generalized reliability index =", BetaHBAR2
  print  "Tvedt event probability =", PFTvedtAR2
  print  "Tvedt generalized reliability index =", BetaTvedtAR2
  print  "************************************************************************************************"
  for i in range(CurvAR2.getDimension()) :
    print "sorted curvatures =" , CurvAR2[i]
  print  "************************************************************************************************"
  for i in range(u_starAR2.getDimension()) :
    print "standard space design point =" , u_starAR2[i]
  print  "************************************************************************************************"
  for i in range(x_starAR2.getDimension()) :
    print "physical space design point =" , x_starAR2[i]
  print  "************************************************************************************************"
  print  "************************************************************************************************"
  print "is standard point origin in failure space? " , PtAR2
  print  "************************************************************************************************"
  for i in range(gammaAR2.getDimension()) :
    print "importance factors =" , gammaAR2[i]
  print  "************************************************************************************************"
  print  "Hasofer reliability index =" , beta_hasoferAR2
  print  "************************************************************************************************"
  print  ""
  print  "************************************************************************************************"
  print  "**************************************** MONTE CARLO *******************************************"
  print  "************************************************************************************************"
  print  "Pf estimation =", PFMC
  print  "Pf Variance estimation =", Variance_PF_MC
  print  "CoV =", CVMC
  print  "90% Confidence Interval =" , length90MC
  print  "CI at 90% =[" , PFMC-0.5*length90MC , ";" , PFMC+0.5*length90MC , "]"
  print  "************************************************************************************************"
  print  ""
  print  "************************************************************************************************"
  print  "******************************************* L H S **********************************************"
  print  "************************************************************************************************"
  print  "Pf estimation =", PFLHS
  print  "Pf Variance estimation =", Variance_PF_LHS
  print  "CoV =", CVLHS
  print  "90% Confidence Interval =" , length90LHS
  print  "CI at 90% =[" , PFLHS-0.5*length90LHS , ";" , PFLHS+0.5*length90LHS , "]"
  print  "************************************************************************************************"
  print  ""

except : 
  import sys
  print "t_Waarts_saddle.py", sys.exc_type, sys.exc_value

