#! /usr/bin/env python

from openturns import *
from math import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

def cleanMatrix(inMatrix) :
  rowDim = inMatrix.getNbRows()
  colDim = inMatrix.getNbColumns()
  for i in range(rowDim) :
    for j in range(colDim) :
      if (fabs(inMatrix[i, j]) < 1.e-10) :
          inMatrix[i, j] = 0.0
  return inMatrix

def cleanSymmetricTensor(inSymmetricTensor) :
  rowDim = inSymmetricTensor.getNbRows()
  colDim = inSymmetricTensor.getNbColumns()
  sheetDim = inSymmetricTensor.getNbSheets()
  for i in range(rowDim) :
    for j in range(colDim) :
      for k in range(sheetDim) :
          if (fabs(inSymmetricTensor[i, j, k]) < 1.e-6) :
            inSymmetricTensor[i, j, k] = 0.0
  return inSymmetricTensor

try :

    # Instanciate one distribution object
    dim = 3
    meanPoint = NumericalPoint(dim, 1.0)
    meanPoint[0] = 0.5
    meanPoint[1] = -0.5
    sigma = NumericalPoint(dim, 1.0)
    sigma[0] = 2.0
    sigma[1] = 3.0
    R = CorrelationMatrix(dim)
    for i in range(1,dim) :  
	R[i, i - 1] = 0.5
    distribution = Normal(meanPoint, sigma, R)

    # Test for sampling
    size = 10000
    sample = distribution.getNumericalSample( size )
    print "sample first=" , sample[0] , " last=" , sample[size - 1] 
    print "sample mean=" , sample.computeMean() 
    print "sample covariance=" , sample.computeCovariance() 

    transform = distribution.getIsoProbabilisticTransformation()
    print "isoprobabilistic transformation=" , transform 
    transformedSample = transform(sample)
    print "transformed sample first=" , transformedSample[0] , " last=" , transformedSample[size - 1] 
    print "transformed sample mean=" , transformedSample.computeMean() 
    print "transformed sample covariance=" , transformedSample.computeCovariance() 

    # Test for evaluation
    inverseTransform = distribution.getInverseIsoProbabilisticTransformation()
    print "inverse isoprobabilistic transformation=" , inverseTransform 
    transformedBackSample = inverseTransform(transformedSample)
    print "transformed back sample first=" , transformedBackSample[0] , " last=" , transformedBackSample[size - 1] 
    print "transformed back sample mean=" , transformedBackSample.computeMean() 
    print "transformed back sample covariance=" , transformedBackSample.computeCovariance() 
    point = NumericalPoint(dim, 1.0)
    print "point=" , point 
    transformedPoint = transform(point)
    print "transform value at point        =" , transformedPoint 
    print "transform gradient at point     =" , cleanMatrix(transform.gradient(point)) 
    print "transform gradient at point (FD)=" , cleanMatrix(CenteredFiniteDifferenceGradient(1.0e-5, transform.getEvaluationImplementation()).gradient(point)) 
    print "transform hessian at point      =" , cleanSymmetricTensor(transform.hessian(point)) 
    print "transform hessian at point (FD) =" , cleanSymmetricTensor(CenteredFiniteDifferenceHessian(1.0e-4, transform.getEvaluationImplementation()).hessian(point)) 
    print "inverse transform value at transformed point        =" , inverseTransform(transformedPoint) 
    print "inverse transform gradient at transformed point (FD)=" , cleanMatrix(inverseTransform.gradient(transformedPoint)) 
    print "inverse transform gradient at transformed point     =" , cleanMatrix(CenteredFiniteDifferenceGradient(1.0e-5, inverseTransform.getEvaluationImplementation()).gradient(transformedPoint)) 
    print "inverse transform hessian at transformed point      =" , cleanSymmetricTensor(inverseTransform.hessian(transformedPoint)) 
    print "inverse transform hessian at transformed point (FD) =" , cleanSymmetricTensor(CenteredFiniteDifferenceHessian(1.0e-4, inverseTransform.getEvaluationImplementation()).hessian(transformedPoint)) 

    # Test for parameters
    print "parameters gradient at point=" , transform.parametersGradient(point) 

except :
  import sys
  print "t_IsoProbabilisticTransformation_EllipticalDistribution.py", sys.exc_type, sys.exc_value
