#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :
    # Instanciate one distribution object
    distribution = Geometric(0.7)
    print "Distribution " , distribution 

    # Is this distribution elliptical ?
    print "Elliptical = ", distribution.isElliptical()

    # Is this distribution continuous ?
    print "Continuous = ", distribution.isContinuous() 

    # Test for realization of distribution
    oneRealization = distribution.getRealization()
    print "oneRealization=", oneRealization 
 
    # Test for sampling
    size = 10000
    oneSample = distribution.getNumericalSample( size )
    print "oneSample first=" , oneSample[0] , " last=" , oneSample[1] 
    print "mean=" , oneSample.computeMean() 
    print "covariance=" , oneSample.computeCovariance() 

    # Define a point
    point = NumericalPoint( distribution.getDimension(), 3.0)
    print "Point= " , point
    
    # Show PDF and CDF of point
    eps = 1e-5
    # PDF value
    PDF = distribution.computePDF( point )
    print  "pdf     =%.6f" % PDF 
    # by the finite difference technique from CDF
    print  "pdf (FD)=%.6f" % (distribution.computeCDF( point + NumericalPoint(1, 0) ) - distribution.computeCDF( point  + NumericalPoint(1, -1) ))
    
    # derivative of the PDF with regards the parameters of the distribution
    CDF = distribution.computeCDF( point )
    print  "cdf=%.6f" % CDF 
    PDFgr = distribution.computePDFGradient( point )
    print  "pdf gradient     =" , PDFgr 
    # by the finite difference technique
    PDFgrFD = NumericalPoint(1)
    PDFgrFD[0] = (Geometric(distribution.getP() + eps).computePDF(point) -
                  Geometric(distribution.getP() - eps).computePDF(point)) / (2.0 * eps)
    print  "pdf gradient (FD)=" , PDFgrFD 
    
    # derivative of the PDF with regards the parameters of the distribution
    CDFgr = distribution.computeCDFGradient( point )
    print  "cdf gradient     =" , CDFgr 
    # by the finite difference technique
    CDFgrFD = NumericalPoint(1)
    CDFgrFD[0] = (Geometric(distribution.getP() + eps).computeCDF(point) -
                  Geometric(distribution.getP() - eps).computeCDF(point)) / (2.0 * eps)
    print  "cdf gradient (FD)=" , CDFgrFD 

    # quantile
    quantile = distribution.computeQuantile( 0.95 )
    print  "quantile=" , quantile 
    print  "cdf(quantile)=%.6f" % distribution.computeCDF(quantile) 
    mean = distribution.getMean()
    print  "mean=" , mean 
    standardDeviation = distribution.getStandardDeviation()
    print "standard deviation=" , standardDeviation 
    skewness = distribution.getSkewness()
    print "skewness=" , skewness 
    kurtosis = distribution.getKurtosis()
    print "kurtosis=" , kurtosis 
    covariance = distribution.getCovariance()
    print  "covariance=" , covariance 
    parameters = distribution.getParametersCollection()
    print  "parameters=" , parameters 

    
except :
  import sys
  print "t_Geometric.py", sys.exc_type, sys.exc_value

