//                                               -*- C++ -*-
/**
 *  @file  t_SensitivityAnalysis_std.cxx
 *  @brief The test file of class SensitivityAnalysis
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy$
 *  @date:   $LastChangedDate$
 *  Id:      $Id$
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "SensitivityAnalysis.hxx"
// #include "NumericalSample.hxx"
// #include "NumericalMathFunction.hxx"
#include "Description.hxx"
#include "Uniform.hxx"
#include "IndependentCopula.hxx"
#include "ComposedDistribution.hxx"
#include "Collection.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Stat;
using namespace OT::Base::Func;
using namespace OT::Base::Type;
using namespace OT::Uncertainty::Model;
using namespace OT::Uncertainty::Distribution;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  try {
    
    RandomGenerator::SetSeed(0);
    
    UnsignedLong inputDimension(3);
    UnsignedLong outputDimension(1);
    
    Description inputName(inputDimension);
    inputName[0] = "X1";
    inputName[1] = "X2";
    inputName[2] = "X3";
    Description outputName(outputDimension);
    outputName[0] = "Y";
    Description formula(1);
    formula[0] = "sin(_pi*X1)+7*sin(_pi*X2)*sin(_pi*X2)+0.1*((_pi*X3)*(_pi*X3)*(_pi*X3)*(_pi*X3))*sin(_pi*X1)";
    
    NumericalMathFunction model(inputName, outputName, formula);
    
    ComposedDistribution::DistributionCollection marginals(inputDimension);
    marginals[0] = Uniform(-1.0,1.0);
//     marginals[0].setDescription("Marginal 1");
    marginals[1] = Uniform(-1.0,1.0);
//     marginals[1].setDescription("Marginal 2");
    marginals[2] = Uniform(-1.0,1.0);
//     marginals[2].setDescription("Marginal 3");
    ComposedDistribution maDistribution(ComposedDistribution(marginals,IndependentCopula(inputDimension)));
    
    
    UnsignedLong size(10000);
    NumericalSample sample1(maDistribution.getNumericalSample(size));
    NumericalSample sample2(maDistribution.getNumericalSample(size));
    
//     for(UnsignedLong i = 0; i < size; ++i)
//     {
//     	for(UnsignedLong j = 0; j < dimension; ++j)
//     	{
//     		sample1[i][j] = (i-0.75)/size;
//     		sample2[i][j] = (i-0.25)/size;
//     	}
//     }
    
    SensitivityAnalysis sensitivitySobol(sample1, sample2, model);
    NumericalPoint firstOrderIndices(sensitivitySobol.getFirstOrderIndices());
    NumericalPoint totalOrderIndices(sensitivitySobol.getTotalOrderIndices());
    
    std::cout << "First order Sobol indice of Y|X1 = " << firstOrderIndices[0] << std::endl;
    std::cout << "Total order Sobol indice of Y|X3 = " << totalOrderIndices[2] << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }
  
  return ExitCode::Success;
}
