//                                               -*- C++ -*-
/**
 *  @file  t_RandomVector_function.cxx
 *  @brief The test file of composite RandomVector class
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-02 14:59:25 +0200 (mer 02 mai 2007) $
 *  Id:      $Id: t_RandomVector_function.cxx 424 2007-05-02 12:59:25Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "RandomVector.hxx"
#include "Normal.hxx"
#include "NumericalMathFunction.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Base::Func;
using namespace OT::Uncertainty::Model;
using namespace OT::Uncertainty::Distribution;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  setRandomGenerator();

  try {

    /* We create a NumericalMathFunction */
    NumericalMathFunction myFunction("wrapper");

    /* We create a distribution */
    UnsignedLong dim(myFunction.getInputNumericalPointDimension());
    CorrelationMatrix R(dim);
    for (UnsignedLong i = 0; i < dim; i++)
      {
	R(i, i) = 1.0;
	for (UnsignedLong j = 0; j < i; j++)
	  {
	    R(i, j) = NumericalScalar(j + 1) / dim;
	  }
      }
    NumericalPoint m(dim, 1.0);
    NumericalPoint s(dim, 2.0);
    Normal distribution(m, s, R);
    const Normal & ref_distribution(distribution);
    std::cout << "distribution = " << ref_distribution << std::endl;


    /* We create a distribution-based RandomVector */
    RandomVector X(distribution);
    std::cout << "X=" << X << std::endl;
    std::cout << "is composite? " << X.isComposite() << std::endl;

    /* Check standard methods of class RandomVector */
    std::cout << "X dimension=" << X.getDimension() << std::endl;
    std::cout << "X realization (first )=" << X.getRealization() << std::endl;
    std::cout << "X realization (second)=" << X.getRealization() << std::endl;
    std::cout << "X realization (third )=" << X.getRealization() << std::endl;
    std::cout << "X sample =" << X.getNumericalSample(5) << std::endl;





    /* We create a composite RandomVector Y from X and myFunction */
    RandomVector Y(myFunction, X);
    std::cout << "Y=" << Y << std::endl;
    std::cout << "is composite? " << Y.isComposite() << std::endl;

    /* Check standard methods of class RandomVector */
    std::cout << "Y dimension=" << Y.getDimension() << std::endl;
    std::cout << "Y realization (first )=" << Y.getRealization() << std::endl;
    std::cout << "Y realization (second)=" << Y.getRealization() << std::endl;
    std::cout << "Y realization (third )=" << Y.getRealization() << std::endl;
    std::cout << "Y sample =" << Y.getNumericalSample(5) << std::endl;



  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
