//                                               -*- C++ -*-
/**
 *  @file  t_QuadraticTaylor_std.cxx
 *  @brief The test file of class QuadraticTaylor for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-02 14:59:25 +0200 (mer 02 mai 2007) $
 *  Id:      $Id: t_QuadraticTaylor_std.cxx 424 2007-05-02 12:59:25Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "NumericalMathFunction.hxx"
#include "QuadraticTaylor.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Uncertainty::Algorithm;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {
    NumericalScalar eps(0.4);
    /** Instance creation */
    NumericalMathFunction myFunc("TestResponseSurface");
    NumericalPoint center(myFunc.getInputNumericalPointDimension());
    for(UnsignedLong i = 0; i < center.getDimension(); i++)
      {
	center[i] = 1.0+i;
      }
    QuadraticTaylor myTaylor(center, myFunc);
    myTaylor.run();
    NumericalMathFunction responseSurface(myTaylor.getResponseSurface());
    std::cout << "myTaylor=" << myTaylor << std::endl;
    std::cout << "responseSurface=" << responseSurface << std::endl;
    std::cout << "myFunc(" << center << ")=" << myFunc(center) << std::endl;
    std::cout << "responseSurface(" << center << ")=" << responseSurface(center) << std::endl;
    NumericalPoint in(center);
    in[0] += eps;
    in[1] -= eps/2;
    std::cout << "myFunc(" << in << ")=" << myFunc(in) << std::endl;
    std::cout << "responseSurface(" << in << ")=" << responseSurface(in) << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
