//                                               -*- C++ -*-
/**
 *  @file  t_NormalityTest_std.cxx
 *  @brief The test file of class Test
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_NormalityTest_std.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>
#include <iomanip>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include <cmath>
#include "NormalityTest.hxx"
#include "NumericalSample.hxx"
#include "Collection.hxx"
#include "SquareMatrix.hxx"
#include "IdentityMatrix.hxx"
#include "TestResult.hxx"
#include "NumericalPoint.hxx"
#include "Distribution.hxx"
#include "Beta.hxx"
#include "Exponential.hxx"
#include "Gamma.hxx"
#include "Geometric.hxx"
#include "Gumbel.hxx"
#include "Histogram.hxx"
#include "Logistic.hxx"
#include "LogNormal.hxx"
#include "Normal.hxx"
#include "Poisson.hxx"
#include "Student.hxx"
#include "Triangular.hxx"
#include "TruncatedNormal.hxx"
#include "Uniform.hxx"
#include "Weibull.hxx"
#include "UserDefined.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Stat;
using namespace OT::Base::Type;
using namespace OT::Uncertainty::Distribution;
using namespace OT::Uncertainty::Model;
using namespace OT::Uncertainty::StatTest;

typedef UserDefined::Pair Pair;
typedef UserDefined::PairCollection PairCollection;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  setRandomGenerator();
  
  Collection<Distribution> continuousDistributionCollection;
  Collection<Distribution> discreteDistributionCollection;
  Collection<Distribution> distributionCollection;

  Beta beta(2.,3.,0.,1.);
  distributionCollection.add(beta);
  continuousDistributionCollection.add(beta);

  Gamma gamma(1.,2.,3.);
  distributionCollection.add(gamma);
  continuousDistributionCollection.add(gamma);

  Gumbel gumbel(1.,2.);
  distributionCollection.add(gumbel);
  continuousDistributionCollection.add(gumbel);

  LogNormal lognormal(1.,1.,2.);
  distributionCollection.add(lognormal);
  continuousDistributionCollection.add(lognormal);

  Logistic logistic(1.,1.);
  distributionCollection.add(logistic);
  continuousDistributionCollection.add(logistic);

  Normal normal(1.,2.);
  distributionCollection.add(normal);
  continuousDistributionCollection.add(normal);

  TruncatedNormal truncatednormal(1.,1.,0.,3.);
  distributionCollection.add(truncatednormal);
  continuousDistributionCollection.add(truncatednormal);

  Student student(4.,10.);
  distributionCollection.add(student);
  continuousDistributionCollection.add(student);

  Triangular triangular(-1.,2.,4.);
  distributionCollection.add(triangular);
  continuousDistributionCollection.add(triangular);

  Uniform uniform(1.,2.);
  distributionCollection.add(uniform);
  continuousDistributionCollection.add(uniform);

  Weibull weibull(1., 1., 2.);
  distributionCollection.add(weibull);
  continuousDistributionCollection.add(weibull);

  Geometric geometric(.5);
  distributionCollection.add(geometric);
  discreteDistributionCollection.add(geometric);

  Poisson poisson(2.);
  distributionCollection.add(poisson);
  discreteDistributionCollection.add(poisson);

  PairCollection collection(3, Pair(NumericalPoint(1), 0.0));

  NumericalPoint point(1);
  point[0] = 1.0;
  collection[0] = Pair(point, 0.3);
  point[0] = 2.0;
  collection[1] = Pair(point, 0.2);
  point[0] = 3.0;
  collection[2] = Pair(point, 0.5);
  UserDefined userdefined(collection);
  distributionCollection.add(userdefined);
  discreteDistributionCollection.add(userdefined);

  UnsignedLong size(10000);

  UnsignedLong continuousDistributionNumber(continuousDistributionCollection.getSize());
  UnsignedLong discreteDistributionNumber(discreteDistributionCollection.getSize());
  UnsignedLong distributionNumber(continuousDistributionNumber + discreteDistributionNumber);
  Collection<NumericalSample> sampleCollection(distributionNumber);
  Collection<NumericalSample> continuousSampleCollection(continuousDistributionNumber);
  Collection<NumericalSample> discreteSampleCollection(discreteDistributionNumber);
  for (UnsignedLong i = 0; i < continuousDistributionNumber; i++)
    {
      continuousSampleCollection[i] = continuousDistributionCollection[i].getNumericalSample(size);
      continuousSampleCollection[i].setName(continuousDistributionCollection[i].getName());
      sampleCollection[i] = continuousSampleCollection[i];
    }
  for (UnsignedLong i = 0; i < discreteDistributionNumber; i++)
    {
      discreteSampleCollection[i] = discreteDistributionCollection[i].getNumericalSample(size);
      discreteSampleCollection[i].setName(discreteDistributionCollection[i].getName());
      sampleCollection[continuousDistributionNumber + i] = discreteSampleCollection[i];
    }
  // Test the normality of several samples using the Anderson Darling test
  NumericalPoint andersonDarlingResult(distributionNumber);
  for (UnsignedLong i = 0; i < distributionNumber; i++)
    {
      TestResult result(NormalityTest::AndersonDarlingNormal(sampleCollection[i]));
      andersonDarlingResult[i] = result.getBinaryQualityMeasure();
      std::cout << "sample " << sampleCollection[i].getName() << " result=" << andersonDarlingResult[i] << std::endl;
    }
  std::cout << "andersonDarlingResult=" << andersonDarlingResult << std::endl;
  // Test the normality of several samples using the Cramer Von Mises test
  NumericalPoint cramerVonMisesResult(distributionNumber);
  for (UnsignedLong i = 0; i < distributionNumber; i++)
    {
      TestResult result(NormalityTest::CramerVonMisesNormal(sampleCollection[i]));
      cramerVonMisesResult[i] = result.getBinaryQualityMeasure();
      std::cout << "sample " << sampleCollection[i].getName() << " result=" << cramerVonMisesResult[i] << std::endl;
    }
  std::cout << "cramerVonMisesResult=" << cramerVonMisesResult << std::endl;
  return ExitCode::Success;
}
