//                                               -*- C++ -*-
/**
 *  @file  t_LibraryLoader_load.cxx
 *  @brief The test file of class LibraryLoader for load method
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-09-28 12:38:16 +0200 (ven 28 sep 2007) $
 *  Id:      $Id: t_LibraryLoader_load.cxx 551 2007-09-28 10:38:16Z dutka $
 */
#include <iostream>
#include <sstream>
#include <fstream>
#include <iomanip>
#include <string>
#include <cstdlib>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "LibraryLoader.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Func;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {
    const String path(std::getenv("OPENTURNS_WRAPPER_PATH"));

    /** Instance creation */
    LibraryLoader & loader = LibraryLoader::GetInstance();

    try {
      String libraryPath1 = path + "/testwrapper_1.so";
      loader.load( libraryPath1.c_str() );
      std::cout << loader << std::endl;

      // reload the same library
      loader.load( libraryPath1.c_str() );
      std::cout << loader << std::endl;

      String libraryPath2 = path + "/testwrapper_2.so";
      loader.load( libraryPath2.c_str() );
      std::cout << loader << std::endl;

    } catch (DynamicLibraryException & ex) {
      throw TestFailed(ex.str());
    }

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
