//                                               -*- C++ -*-
/**
 *  @file  t_Interval_std.cxx
 *  @brief The test file of class Interval for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_Interval_std.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "Interval.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Type;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {
    // The 1D interface
    Interval interval1D(-3, 5);
    std::cout << "interval1D=" << interval1D << std::endl;
    // The default interface
    Interval defaultInterval(2);
    std::cout << "defaultInterval=" << defaultInterval << std::endl;
    // Construction from 2 NumericalPoint
    NumericalPoint p1(2, -1.0);
    NumericalPoint p2(2, 2.0);
    std::cout << "interval from 2 points=" << Interval(p1, p2) << std::endl;
    // Construction from 2 points and 2 flags
    Interval::BoolCollection flag1(2, false);
    Interval::BoolCollection flag2(2, true);
    Interval interval(p1, p2, flag1, flag2);
    std::cout << "interval from 2 points and 2 flags=" << interval << std::endl;
    // Accessors
    std::cout << "lower bound=" << interval.getLowerBound() << std::endl;
    std::cout << "upper bound=" << interval.getUpperBound() << std::endl;
    std::cout << "lower bound flags=" << interval.getFiniteLowerBound() << std::endl;
    std::cout << "upper bound flags=" << interval.getFiniteUpperBound() << std::endl;
    // Check if a given interval is empty
    std::cout << "interval [p1, p2] empty? " << (Interval(p1, p2).isEmpty() ? "true":"false") << std::endl;
    std::cout << "interval [p2, p1] empty? " << (Interval(p2, p1).isEmpty() ? "true":"false") << std::endl;
    // Intersection
    Interval interval1(p1, p2);
    NumericalPoint p3(2);
    p3[0]=0.5;
    p3[1]=-1.5;
    NumericalPoint p4(2);
    p4[0]=1.5;
    p4[1]=2.5;
    Interval interval2(p3, p4);
    std::cout << "intersection of " << interval1 << " and " << interval2 << " equals " << interval1.intersect(interval2) << std::endl;
    // Inside
    NumericalPoint p5((p1 + p2) * 0.5);
    std::cout << "is point " << p5 << " inside " << interval1 << "? " << (interval1.isInside(p5) ? "yes":"no") << std::endl;
    NumericalPoint p6(2.0 * p2);
    std::cout << "is point " << p6 << " inside " << interval1 << "? " << (interval1.isInside(p6) ? "yes":"no") << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
