//                                               -*- C++ -*-
/**
 *  @file  FittingTest.hxx
 *  @brief StatTest implements statistical tests
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: FittingTest.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_FITTINGTEST_HXX
#define OPENTURNS_FITTINGTEST_HXX

#include "Exception.hxx"
#include "TestResult.hxx"
#include "Collection.hxx"
#include "NumericalSample.hxx"
#include "Distribution.hxx"
#include "DistributionFactory.hxx"
#include "Pointer.hxx"

namespace OpenTURNS
{
  namespace Uncertainty
  {
    namespace StatTest
    {

      /**
       * @class FittingTest
       *
       */

      class FittingTest
      {
      public:

	typedef Base::Common::InvalidArgumentException InvalidArgumentException;
        typedef Base::Common::InternalException        InternalException;
	typedef Base::Stat::TestResult                 TestResult;
	typedef Base::Stat::NumericalSample            NumericalSample;
	typedef Model::Distribution                    Distribution;
        typedef Model::DistributionFactory             Factory;
	typedef Base::Type::Collection<Factory>        FactoryCollection;
	typedef Base::Type::Collection<Distribution>   DistributionCollection;

	/** Default constructor, needed by SWIG */
	FittingTest();

	/** Best model for a given numerical sample by BIC */
	static Distribution BestModelBIC(const NumericalSample  & sample,
					 const FactoryCollection & factoryCollection);

	/** Best model for a given numerical sample by BIC */
	static Distribution BestModelBIC(const NumericalSample  & sample,
					 const DistributionCollection & distributionCollection);


	/** Best model for a given numerical sample by Kolmogorov */
	static Distribution BestModelKolmogorov(const NumericalSample  & sample,
						const FactoryCollection & factoryCollection);

	/** Best model for a given numerical sample by Kolmogorov */
	static Distribution BestModelKolmogorov(const NumericalSample  & sample,
						const DistributionCollection & distributionCollection);


	/** Best model for a given numerical sample by ChiSquared */
	static Distribution BestModelChiSquared(const NumericalSample  & sample,
						const FactoryCollection & factoryCollection);

	/** Best model for a given numerical sample by ChiSquared */
	static Distribution BestModelChiSquared(const NumericalSample  & sample,
						const DistributionCollection & distributionCollection);


	/** Bayesian Information Criterion computation */
        static NumericalScalar BIC(const NumericalSample & sample,
  			      const Distribution & distribution,
			      const UnsignedLong estimatedParameters = 0)
	  throw(InvalidArgumentException);

	/** Bayesian Information Criterion computation */
        static NumericalScalar BIC(const NumericalSample & sample,
			      const Factory & factory)
	  throw(InvalidArgumentException);

	/** Kolmogorov fitting test for continuous distributions */
        static TestResult Kolmogorov(const NumericalSample & sample,
                                     const Distribution & distribution,
                                     const NumericalScalar level = 0.95,
				     const UnsignedLong estimatedParameters = 0)
	  throw(InvalidArgumentException);
	  
	/** Kolmogorov fitting test for continuous distributions */
        static TestResult Kolmogorov(const NumericalSample & sample,
                                     const Factory & factory,
                                     const NumericalScalar level = 0.95)
	  throw(InvalidArgumentException);
	  
	/** ChiSquared fitting test for discrete distributions */
	static TestResult ChiSquared(const NumericalSample & sample,
			             const Distribution & distribution,
				     const NumericalScalar level = 0.95,
				     const UnsignedLong estimatedParameters = 0)
	  throw(InvalidArgumentException);	
	
	/** ChiSquared fitting test for discrete distributions */
	static TestResult ChiSquared(const NumericalSample & sample,
			             const Factory & factory,
				     const NumericalScalar level = 0.95)
	  throw(InvalidArgumentException);	
	
      protected:
	/** Generic invocation of a R script for testing a distribution against a sample */
	static TestResult RunRTest(const NumericalSample & sample,
				   const Distribution & distribution,
				   const NumericalScalar level,
				   const UnsignedLong estimatedParameters,
				   const String & testName)
	  throw(InternalException);
      }; /* class FittingTest */

    } /* namespace StatTest */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
#endif /* OPENTURNS_FITTINGTEST_HXX */
