//                                               -*- C++ -*-
/**
 *  @file  ConstantRandomVector.hxx
 *  @brief An implementation class for constant random vectors
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (mer 21 mai 2008) $
 *  Id:      $Id: ConstantRandomVector.hxx 815 2008-05-21 09:21:38Z dutka $
 */
#ifndef OPENTURNS_CONSTANTRANDOMVECTOR_HXX
#define OPENTURNS_CONSTANTRANDOMVECTOR_HXX

#include "OT.hxx"
#include "RandomVectorImplementation.hxx"
#include "NumericalPoint.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {



      /**
       * @class ConstantRandomVector
       *
       * An implementation class for constant random vectors
       */
      class ConstantRandomVector 
	: public RandomVectorImplementation
      {
	CLASSNAME;

      public:

	/** Some typedefs to ease reading */
	typedef Model::RandomVectorImplementation::Antecedent            Antecedent;
	typedef Model::RandomVectorImplementation::NumericalPoint        NumericalPoint;
	typedef Model::RandomVectorImplementation::NumericalSample       NumericalSample;
	typedef Model::RandomVectorImplementation::CovarianceMatrix      CovarianceMatrix;
	typedef Model::RandomVectorImplementation::NumericalMathFunction NumericalMathFunction;
	typedef RandomVectorImplementation::StorageManager               StorageManager;

	/** Default constructor */
	explicit ConstantRandomVector(const OT::Base::Type::NumericalPoint & point,
				      const String & name = OT::DefaultName);


	/** Virtual constructor */
	ConstantRandomVector * clone() const;

	/** Destructor */
	~ConstantRandomVector();

	/** String converter */
	String str() const;




	/* Here is the interface that all derived class must implement */

	/** Dimension accessor */
	UnsignedLong getDimension() const;

	/** Realization accessor */
	NumericalPoint getRealization() const;

	/** Numerical sample accessor */
	NumericalSample getNumericalSample(UnsignedLong size) const;

	/** Mean accessor */
	NumericalPoint getMean() const;

	/** Covariance accessor */
	CovarianceMatrix getCovariance() const;

	/** Get the random vector corresponding to the i-th marginal component */
	Implementation getMarginal(const UnsignedLong i) const throw(InvalidArgumentException);

	/** Get the marginal random vector corresponding to indices components */
	Implementation getMarginal(const Indices & indices) const throw(InvalidArgumentException);

	/** Distribution accessor */
	Distribution getDistribution() const;

	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(const StorageManager::Advocate & adv);	

      protected:

	friend class Base::Common::Factory<ConstantRandomVector>;

	/** Default constructor */
	ConstantRandomVector(const String & name = OT::DefaultName) : RandomVectorImplementation(name) {};
    
      private:

	/** The point where the vector realizes itself */
	Base::Type::NumericalPoint point_;
    
      }; /* class ConstantRandomVector */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_CONSTANTRANDOMVECTOR_HXX */
