//                                               -*- C++ -*-
/**
 *  @file  UserDefinedFactory.cxx
 *  @brief Factory for UserDefined distribution
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: UserDefinedFactory.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include "UserDefinedFactory.hxx"
#include "UserDefined.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      typedef UserDefined::PairCollection PairCollection;

      /* Default constructor */
      UserDefinedFactory::UserDefinedFactory()
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

      /* Virtual constructor */
      UserDefinedFactory * UserDefinedFactory::clone() const
      {
	return new UserDefinedFactory(*this);
      }


      /* Here is the interface that all derived class must implement */

      UserDefinedFactory::DistributionImplementation * UserDefinedFactory::buildImplementation(const NumericalSample & sample) const throw(InvalidArgumentException, InternalException)
      {
	if (sample.getSize() == 0) throw InvalidArgumentException(HERE) << "Error: cannot build a UserDefined distribution from an empty sample";
	const UnsignedLong size(sample.getSize());
	const NumericalScalar p(1.0 / NumericalScalar(size));
	PairCollection support(size);
	for (UnsignedLong i = 0; i < size; ++i)
	  {
	    support[i].setX(sample[i]);
	    support[i].setP(p);
	  }
	return UserDefined(support).clone();
      }


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
