//                                               -*- C++ -*-
/**
 *  @file  NormalCopulaFactory.hxx
 *  @brief Factory for NormalCopula distribution
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: NormalCopulaFactory.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_NORMALCOPULAFACTORY_HXX
#define OPENTURNS_NORMALCOPULAFACTORY_HXX

#include "OT.hxx"
#include "DistributionImplementationFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      /**
       * @class NormalCopulaFactory
       */
      class NormalCopulaFactory
	: public Model::DistributionImplementationFactory
      {
      public:

	typedef Model::DistributionImplementationFactory                    DistributionImplementationFactory; // required by SWIG
	typedef DistributionImplementationFactory::NumericalSample          NumericalSample;
	typedef DistributionImplementationFactory::InternalException        InternalException;
	typedef DistributionImplementationFactory::InvalidArgumentException InvalidArgumentException;
	typedef Model::DistributionImplementation                           DistributionImplementation;

	/** Default constructor */
	NormalCopulaFactory();

	/** Virtual constructor */
	virtual NormalCopulaFactory * clone() const;

	/* Here is the interface that all derived class must implement */

	virtual DistributionImplementation * buildImplementation(const NumericalSample & sample) const throw(InvalidArgumentException, InternalException);

    
      }; /* class NormalCopulaFactory */


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NORMALCOPULAFACTORY_HXX */
