//                                               -*- C++ -*-
/**
 *  @file  IndependentCopula.hxx
 *  @brief A class that implements an independent copula
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: IndependentCopula.hxx 995 2008-10-31 10:52:04Z dutka $
 */
#ifndef OPENTURNS_INDEPENDENTCOPULA_HXX
#define OPENTURNS_INDEPENDENTCOPULA_HXX

#include "OT.hxx"
#include "CopulaImplementation.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {


      /**
       * @class IndependentCopula
       *
       * The class implements an independent copula
       */
      class IndependentCopula 
	: public Model::CopulaImplementation
      {
	CLASSNAME;
      public:
	typedef Model::CopulaImplementation                                 CopulaImplementation; // required by SWIG
	typedef CopulaImplementation::NotDefinedException                   NotDefinedException;
	typedef CopulaImplementation::NumericalPoint                        NumericalPoint;
	typedef CopulaImplementation::NumericalSample                       NumericalSample;
	typedef CopulaImplementation::Implementation                        Implementation;
	typedef CopulaImplementation::CovarianceMatrix                      CovarianceMatrix;
	typedef CopulaImplementation::IsoProbabilisticTransformation        IsoProbabilisticTransformation;
	typedef CopulaImplementation::InverseIsoProbabilisticTransformation InverseIsoProbabilisticTransformation;
	typedef CopulaImplementation::NumericalPointWithDescriptionCollection              NumericalPointWithDescriptionCollection;
	typedef CopulaImplementation::StorageManager                        StorageManager;

	/** Default constructor */
	explicit IndependentCopula(const UnsignedLong dimension = 1);


	/** Comparison operator */
	Bool operator ==(const IndependentCopula & other) const;

	/** String converter */
	String str() const;

	/* Interface inherited from Distribution */

	/** Virtual constructor */
	virtual IndependentCopula * clone() const;

	/** Get one realization of the IndependentCopula distribution */
	NumericalPoint getRealization() const;

	/** Get the DDF of the distribution */
	using CopulaImplementation::computeDDF;
	NumericalPoint computeDDF(const NumericalPoint & point) const;

	/** Get the PDF of the IndependentCopula distribution */
	using CopulaImplementation::computePDF;
	NumericalScalar computePDF(const NumericalPoint & point) const;

	/** Get the CDF of the IndependentCopula distribution */
	using CopulaImplementation::computeCDF;
	NumericalScalar computeCDF(const NumericalPoint & point, const Bool tail = false) const;

	/** Get the probability content of an interval */
	NumericalScalar computeProbability(const Interval & interval) const;

	/** Get the PDF gradient of the distribution */
	NumericalPoint computePDFGradient(const NumericalPoint & point) const;

	/** Get the CDF gradient of the distribution */
	NumericalPoint computeCDFGradient(const NumericalPoint & point) const;

	/** Get the quantile of the IndependentCopula distribution */
	NumericalPoint computeQuantile(const NumericalScalar prob) const;

	/** Get the covariance of the distribution */
        CovarianceMatrix getCovariance() const throw(NotDefinedException);

	/** Get the distribution of the marginal distribution corresponding to indices dimensions */
	using CopulaImplementation::getMarginal;
	Implementation getMarginal(const Indices & indices) const throw(InvalidArgumentException);

	/** Compute the DDF of Xi | X1, ..., Xi-1. x = Xi, y = (X1,...,Xi-1) */
	virtual NumericalScalar computeConditionalDDF(const NumericalScalar x, const NumericalPoint & y) const;

	/** Compute the PDF of Xi | X1, ..., Xi-1. x = Xi, y = (X1,...,Xi-1) */
	virtual NumericalScalar computeConditionalPDF(const NumericalScalar x, const NumericalPoint & y) const;

	/** Compute the CDF of Xi | X1, ..., Xi-1. x = Xi, y = (X1,...,Xi-1) */
	virtual NumericalScalar computeConditionalCDF(const NumericalScalar x, const NumericalPoint & y) const;

	/** Compute the quantile of Xi | X1, ..., Xi-1, i.e. x such that CDF(x|y) = q with x = Xi, y = (X1,...,Xi-1) */
	virtual NumericalScalar computeConditionalQuantile(const NumericalScalar q, const NumericalPoint & y) const;

	/** Get the isoprobabilistic transformation */
	IsoProbabilisticTransformation getIsoProbabilisticTransformation() const;

	/** Get the inverse isoprobabilistic transformation */
	InverseIsoProbabilisticTransformation getInverseIsoProbabilisticTransformation() const;

	/** Get the standard distribution, i.e. a distribution of the same kind but with zero mean,
	 * unit marginal standard distribution and identity correlation */
	Implementation getStandardDistribution() const;

	/** Parameters value and description accessor */
	virtual NumericalPointWithDescriptionCollection getParametersCollection() const;

	/** Method save() stores the object through the StorageManager */
	virtual void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	virtual void load(const StorageManager::Advocate & adv);	

      protected:

      private:

      }; /* class IndependentCopula */


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_INDEPENDENTCOPULA_HXX */
