//                                               -*- C++ -*-
/**
 *  @file  GumbelCopulaFactory.hxx
 *  @brief Factory for GumbelCopula distribution
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-10 16:43:31 +0200 (jeu, 10 mai 2007) $
 *  Id:      $Id: GumbelCopulaFactory.hxx 434 2007-05-10 14:43:31Z dutka $
 */
#ifndef OPENTURNS_GUMBELCOPULAFACTORY_HXX
#define OPENTURNS_GUMBELCOPULAFACTORY_HXX

#include "OT.hxx"
#include "DistributionImplementationFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      /**
       * @class GumbelCopulaFactory
       */
      class GumbelCopulaFactory
	: public Model::DistributionImplementationFactory
      {
      public:

	typedef Model::DistributionImplementationFactory                    DistributionImplementationFactory; // required by SWIG
	typedef DistributionImplementationFactory::NumericalSample          NumericalSample;
	typedef DistributionImplementationFactory::InternalException        InternalException;
	typedef DistributionImplementationFactory::InvalidArgumentException InvalidArgumentException;
	typedef Model::DistributionImplementation                           DistributionImplementation;

	/** Default constructor */
	GumbelCopulaFactory();

	/** Virtual constructor */
	virtual GumbelCopulaFactory * clone() const;

	/* Here is the interface that all derived class must implement */

	virtual DistributionImplementation * buildImplementation(const NumericalSample & sample) const throw(InvalidArgumentException, InternalException);

    
      }; /* class GumbelCopulaFactory */


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_GUMBELCOPULAFACTORY_HXX */
