//                                               -*- C++ -*-
/**
 *  @file  RosenblattEvaluation.hxx
 *  @brief Class for the Nataf transformationEvaluation evaluation for elliptical
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2008-07-03 08:31:34 +0200 (jeu, 03 jui 2008) $
 *  Id:      $Id: RosenblattEvaluation.hxx 867 2008-07-03 06:31:34Z lebrun $
 */
#ifndef OPENTURNS_ROSENBLATTEVALUATION_HXX
#define OPENTURNS_ROSENBLATTEVALUATION_HXX

#include "OT.hxx"
#include "NumericalMathEvaluationImplementation.hxx"
#include "Matrix.hxx"
#include "NumericalPoint.hxx"
#include "Distribution.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /**
       * @class RosenblattEvaluation
       *
       * This class offers an interface for the Nataf function for elliptical distributions
       */
      class RosenblattEvaluation
	: public Base::Func::NumericalMathEvaluationImplementation
      {
	CLASSNAME;
      public:

	typedef Base::Func::NumericalMathEvaluationImplementation NumericalMathEvaluationImplementation;
	typedef Base::Type::Matrix                                Matrix;
	typedef Base::Type::NumericalPoint                        NumericalPoint;
	typedef Model::Distribution                               Distribution;
	typedef Base::Common::InternalException                   InternalException;
	typedef Base::Common::InvalidArgumentException            InvalidArgumentException;

	/** Parameter constructor */
	RosenblattEvaluation(const Distribution & distribution);

	/** Virtual constructor */
	virtual RosenblattEvaluation * clone() const;

	/** Evaluation */
	NumericalPoint operator () (const NumericalPoint & in) const
	  throw (InvalidArgumentException, InternalException);

	/** Gradient according to the marginal parameters */
	virtual Matrix parametersGradient(const NumericalPoint & in) const;
	  
	/** Accessor for input point dimension */
	virtual UnsignedLong getInputNumericalPointDimension() const
	  throw(InternalException);

	/** Accessor for output point dimension */
	virtual UnsignedLong getOutputNumericalPointDimension() const
	  throw(InternalException);

	/** String converter */
	virtual String str() const;

      protected:

    
      private:
	Distribution distribution_;

      }; /* RosenblattEvaluation */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ROSENBLATTEVALUATION_HXX */
