//                                               -*- C++ -*-
/**
 *  @file  InverseNatafEllipticalDistributionEvaluation.hxx
 *  @brief Class for the InverseNataf transformation evaluation for elliptical
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: InverseNatafEllipticalDistributionEvaluation.hxx 995 2008-10-31 10:52:04Z dutka $
 */
#ifndef OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONEVALUATION_HXX
#define OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONEVALUATION_HXX

#include "OT.hxx"
#include "LinearNumericalMathEvaluationImplementation.hxx"
#include "SquareMatrix.hxx"
#include "NumericalPoint.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /**
       * @class InverseNatafEllipticalDistributionEvaluation
       *
       * This class offers an interface for the InverseNataf function for elliptical distributions
       */
      class InverseNatafEllipticalDistributionEvaluation
	: public Base::Func::LinearNumericalMathEvaluationImplementation
      {
	CLASSNAME;
      public:

	typedef Base::Func::LinearNumericalMathEvaluationImplementation LinearNumericalMathEvaluationImplementation;
	typedef Base::Type::SquareMatrix                              SquareMatrix;
	typedef Base::Type::NumericalPoint                            NumericalPoint;

	/** Parameter constructor */
	InverseNatafEllipticalDistributionEvaluation(const NumericalPoint & mean,
						     const SquareMatrix & cholesky);


	/** Destructor */
	virtual ~InverseNatafEllipticalDistributionEvaluation();

	/** Gradient according to the marginal parameters */
	virtual Matrix parametersGradient(const NumericalPoint & in) const;
	  
	/** String converter */
	virtual String str() const;

      protected:

    
      private:

      }; /* InverseNatafEllipticalDistributionEvaluation */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONEVALUATION_HXX */
