//                                               -*- C++ -*-
/**
 *  @file  MarginalTransformationHessian.hxx
 *  @brief Class for the Nataf transformationHessian evaluation for elliptical
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: MarginalTransformationHessian.hxx 995 2008-10-31 10:52:04Z dutka $
 */
#ifndef OPENTURNS_MARGINALTRANSFORMATIONHESSIAN_HXX
#define OPENTURNS_MARGINALTRANSFORMATIONHESSIAN_HXX

#include "NumericalMathHessianImplementation.hxx"
#include "NumericalPoint.hxx"
#include "SymmetricTensor.hxx"
#include "Collection.hxx"
#include "Distribution.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /**
       * @class MarginalTransformationHessian
       *
       * This class offers an interface for the Nataf function for elliptical distributions
       */
      class MarginalTransformationHessian
	: public Base::Func::NumericalMathHessianImplementation
      {
	CLASSNAME;
      public:

	typedef Base::Func::NumericalMathHessianImplementation NumericalMathHessianImplementation;
	typedef Base::Type::SymmetricTensor                    SymmetricTensor;
	typedef Base::Type::NumericalPoint                     NumericalPoint;
	typedef Model::Distribution                            Distribution;
	typedef Base::Type::Collection<Distribution>           DistributionCollection;
	typedef Base::Common::InternalException                InternalException;
	typedef Base::Common::InvalidArgumentException         InvalidArgumentException;

	/** Parameter constructor */
	MarginalTransformationHessian(const DistributionCollection & distributionCollection);


	/** Virtual constructor */
	virtual MarginalTransformationHessian * clone() const;

	/** Hessian */
	SymmetricTensor hessian(const NumericalPoint & in) const
	  throw (InvalidArgumentException, InternalException);
	  
	/** Accessor for input point dimension */
	virtual UnsignedLong getInputNumericalPointDimension() const
	  throw(InternalException);

	/** Accessor for output point dimension */
	virtual UnsignedLong getOutputNumericalPointDimension() const
	  throw(InternalException);

	/** String converter */
	virtual String str() const;

      protected:

    
      private:
	DistributionCollection distributionCollection_;

      }; /* MarginalTransformationHessian */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_MARGINALTRANSFORMATIONHESSIAN_HXX */
