//                                               -*- C++ -*-
/**
 *  @file  InverseMarginalTransformationGradient.hxx
 *  @brief Class for the Nataf transformationGradient evaluation for elliptical
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: InverseMarginalTransformationGradient.hxx 995 2008-10-31 10:52:04Z dutka $
 */
#ifndef OPENTURNS_INVERSEMARGINALTRANSFORMATIONGRADIENT_HXX
#define OPENTURNS_INVERSEMARGINALTRANSFORMATIONGRADIENT_HXX

#include "OT.hxx"
#include "NumericalMathGradientImplementation.hxx"
#include "Matrix.hxx"
#include "NumericalPoint.hxx"
#include "Collection.hxx"
#include "Distribution.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /**
       * @class InverseMarginalTransformationGradient
       *
       * This class offers an interface for the Nataf function for elliptical distributions
       */
      class InverseMarginalTransformationGradient
	: public Base::Func::NumericalMathGradientImplementation
      {
	CLASSNAME;
      public:

	typedef Base::Func::NumericalMathGradientImplementation NumericalMathGradientImplementation;
	typedef Base::Type::Matrix                              Matrix;
	typedef Base::Type::NumericalPoint                      NumericalPoint;
	typedef Model::Distribution                             Distribution;
	typedef Base::Type::Collection<Distribution>            DistributionCollection;
	typedef Base::Common::InternalException                 InternalException;
	typedef Base::Common::InvalidArgumentException          InvalidArgumentException;

	/** Parameter constructor */
	InverseMarginalTransformationGradient(const DistributionCollection & distributionCollection);


	/** Virtual constructor */
	virtual InverseMarginalTransformationGradient * clone() const;

	/** Gradient */
	Matrix gradient(const NumericalPoint & in) const
	  throw (InvalidArgumentException, InternalException);
	  
	/** Accessor for input point dimension */
	virtual UnsignedLong getInputNumericalPointDimension() const
	  throw(InternalException);

	/** Accessor for output point dimension */
	virtual UnsignedLong getOutputNumericalPointDimension() const
	  throw(InternalException);

	/** String converter */
	virtual String str() const;

      protected:

    
      private:
	DistributionCollection distributionCollection_;

      }; /* InverseMarginalTransformationGradient */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_INVERSEMARGINALTRANSFORMATIONGRADIENT_HXX */
