//                                               -*- C++ -*-
/**
 *  @file  Experiment.hxx
 *  @brief Abstract top-level view of an experiment plane
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-02 14:59:25 +0200 (mer 02 mai 2007) $
 *  Id:      $Id: Experiment.hxx 424 2007-05-02 12:59:25Z dutka $
 */
#ifndef OPENTURNS_EXPERIMENT_HXX
#define OPENTURNS_EXPERIMENT_HXX

#include "TypedInterfaceObject.hxx"
#include "ExperimentImplementation.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      /**
       * @class Experiment
       *
       * The class describes the probabilistic concept of experiment plan
       */
      class Experiment
	: public Base::Common::TypedInterfaceObject<ExperimentImplementation>
      {
	CLASSNAME;
      public:

	typedef ExperimentImplementation::NumericalPoint  NumericalPoint;
	typedef ExperimentImplementation::NumericalSample NumericalSample;
	typedef ExperimentImplementation::Implementation  Implementation;

	/** Default constructor */
	explicit Experiment(const String & name = OT::DefaultName);

	/** Constructor from implementation */
	Experiment(const ExperimentImplementation & implementation,
                   const String & name = OT::DefaultName);

#ifndef SWIG
	/** Constructor from implementation pointer */
	Experiment(const Implementation & p_implementation,
                   const String & name = OT::DefaultName);
#endif

	/** Constructor with parameters */
	explicit Experiment(const NumericalPoint & center,
			    const NumericalPoint & levels,
			    const String & name = OT::DefaultName);


	/** String converter */
	virtual String str() const;

	/** Center accessor */
	virtual void setCenter(const NumericalPoint & center);

	/** Center accessor */
	virtual NumericalPoint getCenter() const;

	/** Levels accessor */
	virtual void setLevels(const NumericalPoint & levels);

	/** Levels accessor */
	virtual NumericalPoint getLevels() const;

	/** Sample generation */
	virtual NumericalSample generate();

	/** Implementation accessor */
	void setImplementation(const Implementation & p_implementation);

      }; /* class Experiment */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_EXPERIMENT_HXX */
