//                                               -*- C++ -*-
/**
 *  @file  NumericalPointImplementationWithDescription.cxx
 *  @brief NumericalPointImplementationWithDescription extends the classical mathematical point with a description of the coordinates
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: NumericalPointImplementationWithDescription.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include "NumericalPointImplementationWithDescription.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Type
    {

      CLASSNAMEINIT(NumericalPointImplementationWithDescription);
      TEMPLATE_CLASSNAMEINIT(PersistentCollection<NumericalPointImplementationWithDescription>);

      static Common::Factory<NumericalPointImplementationWithDescription> RegisteredFactory1("NumericalPointImplementationWithDescription");
      static Common::Factory<PersistentCollection<NumericalPointImplementationWithDescription> > RegisteredFactory2("PersistentCollection<NumericalPointImplementationWithDescription>");

      /* Default constructor */
      NumericalPointImplementationWithDescription::NumericalPointImplementationWithDescription()
	: NumericalPointImplementation(),
	  p_description_()
      {
        // Nothing to do
      }

      /* Constructor with size */
      NumericalPointImplementationWithDescription::NumericalPointImplementationWithDescription(const UnsignedLong size,
											       const NumericalScalar value)
	: NumericalPointImplementation(size, value),
	  p_description_()
      {
        // Nothing to do
      }



      /* Constructor from a collection */
      NumericalPointImplementationWithDescription::NumericalPointImplementationWithDescription(const Type::Collection<NumericalScalar> & coll)
	: NumericalPointImplementation(coll),
	  p_description_()
      {
        // Nothing to do
      }

      /* Constructor from a base class */
      NumericalPointImplementationWithDescription::NumericalPointImplementationWithDescription(const Common::Pointer<NumericalPointImplementation> & p_base)
	: NumericalPointImplementation(*p_base),
	  p_description_()
      {
	// Nothing to do
      }



      /* Virtual constructor */
      NumericalPointImplementationWithDescription * NumericalPointImplementationWithDescription::clone() const
      {
	return new NumericalPointImplementationWithDescription(*this);
      }


      /* String converter */
      String NumericalPointImplementationWithDescription::str() const
      {
	return OSS() << "class=" << NumericalPointImplementationWithDescription::GetClassName()
		     << " name=" << getName()
		     << " dimension=" << getDimension()
		     << " description=" << getDescription()
		     << " values=" << PersistentCollection<NumericalScalar>::str();
      }




      /* Description Accessor */
      void NumericalPointImplementationWithDescription::setDescription(const Description & description)
      {
	p_description_ = description.getImplementation();
      }


      /* Description Accessor */
      Description NumericalPointImplementationWithDescription::getDescription() const
      {
	return p_description_.isNull() ? Description(getDimension()) : *p_description_;
      }


      

      /* Method save() stores the object through the StorageManager */
      void NumericalPointImplementationWithDescription::save(const StorageManager::Advocate & adv) const
      {
	NumericalPointImplementation::save(adv);
	if (!p_description_.isNull())
	  adv.writeValue(*p_description_, StorageManager::MemberNameAttribute, "p_description_");
      }


      /* Method load() reloads the object from the StorageManager */
      void NumericalPointImplementationWithDescription::load(const StorageManager::Advocate & adv)
      {
	NumericalPointImplementation::load(adv);
	Description description;
	adv.readValue(description, StorageManager::MemberNameAttribute, "p_description_");
	if (description.getSize() != 0) setDescription(description);
      }


    } /* namespace Type */
  } /* namespace Base */
} /* namespace OpenTURNS */
