//                                               -*- C++ -*-
/**
 *  @file  IdentityMatrix.hxx
 *  @brief The class IdentityMatrix implements identity matrices
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: IdentityMatrix.hxx 995 2008-10-31 10:52:04Z dutka $
 */
#ifndef OPENTURNS_IDENTITYMATRIX_HXX
#define OPENTURNS_IDENTITYMATRIX_HXX

#include "OT.hxx"
#include "CorrelationMatrix.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Type
    {

      /**
       * @class IdentityMatrix
       */

      class IdentityMatrix
	: public Stat::CorrelationMatrix
      {
	CLASSNAME;
	
      public:

	typedef Stat::CovarianceMatrix  CovarianceMatrix;
	typedef Stat::CorrelationMatrix CorrelationMatrix;

	/** Default constructor */
	IdentityMatrix();
	 
	/** Constructor with size */ 
	IdentityMatrix(const UnsignedLong dim);

	
	/** String converter */
	virtual String str() const;

	/** IdentityMatrix transpose */
	IdentityMatrix transpose () const ;
	
#ifndef SWIG
	/** Operator () gives access to the elements of the matrix (read only) */
	/** The element of the matrix is designated by its row number i and its column number j */
	const NumericalScalar & operator () (const UnsignedLong i,
					     const UnsignedLong j) const throw(InvalidDimensionException);
#endif
	
	/** Multiplications */
	Matrix operator * (const Matrix & m) const throw(InvalidDimensionException);
	SquareMatrix operator * (const SquareMatrix & m) const throw(InvalidDimensionException);
	SymmetricMatrix operator * (const SymmetricMatrix & m) const throw(InvalidDimensionException);
	CovarianceMatrix operator * (const CovarianceMatrix & m) const throw(InvalidDimensionException);
	CorrelationMatrix operator * (const CorrelationMatrix & m) const throw(InvalidDimensionException);
	using CorrelationMatrix::operator *;
	
	/** Resolution of a linear system */
	NumericalPoint solveLinearSystem(const NumericalPoint & b) const throw(InvalidDimensionException);
	
	MatrixImplementation solveLinearSystem(const MatrixImplementation & b) const throw(InvalidDimensionException);
	
	/** Compute determinant */
	NumericalScalar computeDeterminant() const;
	
	/** Compute eigenvalues */
	NumericalPoint computeEigenValues() const;
	          
	/** Check if the matrix is SPD */
	virtual Bool isPositiveDefinite() const;
	
	/** Build the Cholesky factorization of the matrix */
	SquareMatrix computeCholesky() const ;
	            
      protected:

            
        /** Constructor with implementation */
        IdentityMatrix(const Implementation & i);
      
      private:
      
        /** Operator () gives access to the elements of the matrix (to modify these elements) */
	/** The element of the matrix is designated by its row number i and its column number j */
	NumericalScalar & operator () (const UnsignedLong i,
				       const UnsignedLong j) throw(InvalidDimensionException);
      }

      ; /* class IdentityMatrix */



    } /* namespace Type */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COVARIANCEMATRIX_HXX */
