//                                               -*- C++ -*-
/**
 *  @file  DescriptionImplementation.hxx
 *  @brief DescriptionImplementation is the active part of Description
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: DescriptionImplementation.hxx 995 2008-10-31 10:52:04Z dutka $
 */
#ifndef OPENTURNS_DESCRIPTIONIMPLEMENTATION_HXX
#define OPENTURNS_DESCRIPTIONIMPLEMENTATION_HXX

#include "PersistentCollection.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Type
    {

      /**
       * @class DescriptionImplementation
       *
       * DescriptionImplementation is the active part of Description
       */

      class DescriptionImplementation
	: public PersistentCollection<String>
      {
	CLASSNAME;

      public:

	typedef PersistentCollection<String>::ElementType ElementType;
	typedef Common::StorageManager                    StorageManager;

	/** Default constructor */
	DescriptionImplementation();

	/** Constructor with size */
	DescriptionImplementation(const UnsignedLong size);	

	/** Constructor with default value */
	DescriptionImplementation(const String & value);	
	
	/** Constructor with size and default value */
	DescriptionImplementation(const UnsignedLong size,
				  const String & value);	
	
	/** Virtual constructor */
	virtual DescriptionImplementation * clone() const;

	/** String converter */
	virtual String str() const;

	/** Method save() stores the object through the StorageManager */
	virtual void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(const StorageManager::Advocate & adv);
 
      }; /* class DescriptionImplementation */


    } /* namespace Type */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_DESCRIPTIONIMPLEMENTATION_HXX */
