//                                               -*- C++ -*-
/**
 *  @file  Last.hxx
 *  @brief This class is a top-level class for the history mechanism of
 *  simulation algorithms. It delegates to its children the effective
 *  history strategy.
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: Last.hxx 995 2008-10-31 10:52:04Z dutka $
 */
#ifndef OPENTURNS_LAST_HXX
#define OPENTURNS_LAST_HXX

#include "HistoryStrategyImplementation.hxx"
#include "NumericalSample.hxx"

namespace OpenTURNS
{

  namespace Base 
  {

    namespace Stat
    {

      /**
       * @class Last
       */

      class Last
	: public HistoryStrategyImplementation
      {

	CLASSNAME;

      public:

	static const UnsignedLong DefaultMaximumSize = 65536;

	typedef HistoryStrategyImplementation::NumericalPoint NumericalPoint;

	/** Constructor with parameters */
	explicit Last();

	/** Constructor with parameters */
	explicit Last(const UnsignedLong maximumSize);

	/** Virtual constructor */
	virtual Last * clone() const;

	/** Store the point according to the strategy */
	void store(const NumericalPoint & point);

	/** Sample accessor */
	NumericalSample getSample() const;

	/** MaximumSize accessor */
	UnsignedLong getMaximumSize() const;

	/** Index accessor */
	UnsignedLong getIndex() const;

	/** Wrapped flag accessor */
	Bool getHasWrapped() const;

	/** String converter */
	String str() const;

      protected:

      private:
	// Maximum number of points to be hitorized
	UnsignedLong maximumSize_;

	// Index where the next point will be stored
	UnsignedLong index_;;

	// Flag that tells if the storage has already exceeded maximumSize_
	Bool hasWrapped_;;

      } ; /* class Last */

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LAST_HXX */
