//                                               -*- C++ -*-
/**
 *  @file  HistoryStrategyImplementation.cxx
 *  @brief 
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: HistoryStrategyImplementation.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include "HistoryStrategyImplementation.hxx"
#include "Exception.hxx"

namespace OpenTURNS
{

  namespace Base 
  {

    namespace Stat
    {

      typedef Base::Common::NotYetImplementedException NotYetImplementedException;

      /**
       * @class HistoryStrategyImplementation
       */

      CLASSNAMEINIT(HistoryStrategyImplementation);

      /* Constructor with parameters */
      HistoryStrategyImplementation::HistoryStrategyImplementation()
	: Base::Common::PersistentObject(),
	  sample_(),
	  isInitialized_(false)
      {
	// Nothing to do
      }

      /* Virtual constructor */
      HistoryStrategyImplementation * HistoryStrategyImplementation::clone() const
      {
	return new HistoryStrategyImplementation(*this);
      }

      /* Store the point according to the strategy */
      void HistoryStrategyImplementation::store(const NumericalPoint & point)
      {
	throw NotYetImplementedException(HERE);
      }

      /* Reset the history storage through the isInitialized_ flag */
      void HistoryStrategyImplementation::reset()
      {
	isInitialized_ = false;
	sample_ = NumericalSample();
      }

      /* History sample accessor */
      NumericalSample HistoryStrategyImplementation::getSample() const
      {
	return sample_;
      }

      /* String converter */
      String HistoryStrategyImplementation::str() const
      {
	OSS oss;
	oss << "class=" << HistoryStrategyImplementation::GetClassName();
	return oss;
      }

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */
