//                                               -*- C++ -*-
/**
 *  @file  SQPSpecificParameters.cxx
 *  @brief SpecificParameters is an encapsulation of the SQP specific
 *         parameters.
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: SQPSpecificParameters.cxx 862 2008-06-26 11:50:17Z dutka $
 */

#include "SQP.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optimisation
    {

      /* Multiplicative decrease of linear step */
      const NumericalScalar SQP::SpecificParameters::DefaultTau = 0.5;
      /* Armijo factor */
      const NumericalScalar SQP::SpecificParameters::DefaultOmega = 1e-4;
      /* Growing factor in penalization term */
      const NumericalScalar SQP::SpecificParameters::DefaultSmooth = 1.2;

      CLASSNAMEINIT(SQP::SpecificParameters);

      /* Default onstructor */
      SQP::SpecificParameters::SpecificParameters():
	PersistentObject(),
	tau_(SQP::SpecificParameters::DefaultTau),
	omega_(SQP::SpecificParameters::DefaultOmega),
	smooth_(SQP::SpecificParameters::DefaultSmooth)
      {
	// Nothing to do
      } /* SpecificParametersSQP */

      /* Constructor with parameters */
      SQP::SpecificParameters::SpecificParameters(const NumericalScalar tau,
							   const NumericalScalar omega,
							   const NumericalScalar smooth):
	PersistentObject(),
	tau_(tau),
	omega_(omega),
	smooth_(smooth)
      {
	// Nothing to do
      } /* SpecificParametersSQP */

      /* Virtual constructor */
      SQP::SpecificParameters * SQP::SpecificParameters::clone() const
      {
	return new SpecificParameters(*this);
      }

      /* Tau accessor */
      NumericalScalar SQP::SpecificParameters::getTau() const
      {
	return tau_;
      }

      /* Tau accessor */
      void SQP::SpecificParameters::setTau(const NumericalScalar tau)
      {
        tau_ = tau;
      }

      /* Omega accessor */
      NumericalScalar SQP::SpecificParameters::getOmega() const
      {
	return omega_;
      }

      /* Omega accessor */
      void SQP::SpecificParameters::setOmega(const NumericalScalar omega)
      {
        omega_ = omega;
      }

      /* Smooth accessor */
      NumericalScalar SQP::SpecificParameters::getSmooth() const
      {
	return smooth_;
      }

      /* Smooth accessor */
      void SQP::SpecificParameters::setSmooth(const NumericalScalar smooth)
      {
        smooth_ = smooth;
      }

      /* String converter */
      String SQP::SpecificParameters::str() const
      {
	OSS oss;
	oss << "class=" << SQP::SpecificParameters::GetClassName()
            << " tau=" << tau_
            << " omega=" << omega_
            << " smooth=" << smooth_;
	return oss;
      }

    } /* namespace Optimisation */
  } /* namespace Base */
} /* namespace OpenTURNS */



