//                                               -*- C++ -*-
/**
 *  @file  CobylaSpecificParameters.cxx
 *  @brief SpecificParameters is an encapsulation of the Cobyla specific
 *         parameters.
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-09-10 15:54:48 +0200 (lun 10 sep 2007) $
 *  Id:      $Id: CobylaSpecificParameters.cxx 503 2007-09-10 13:54:48Z dutka $
 */

#include "Cobyla.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optimisation
    {

      const NumericalScalar Cobyla::SpecificParameters::DefaultRhoBeg = 0.1;

      CLASSNAMEINIT(Cobyla::SpecificParameters);

      /* Default with parameters */
      Cobyla::SpecificParameters::SpecificParameters():
	PersistentObject(),
	rhoBeg_(Cobyla::SpecificParameters::DefaultRhoBeg)
      {
	// Nothing to do
      } /* SpecificParametersCobyla */

      /* Parameters with parameters */
      Cobyla::SpecificParameters::SpecificParameters(const NumericalScalar rhoBeg):
	PersistentObject()
      {
	// Nothing to do
      } /* SpecificParametersCobyla */

      /* Virtual constructor */
      Cobyla::SpecificParameters * Cobyla::SpecificParameters::clone() const
      {
	return new SpecificParameters(*this);
      }

      /* RhoBeg accessor */
      NumericalScalar Cobyla::SpecificParameters::getRhoBeg() const
      {
	return rhoBeg_;
      }

      /* RhoBeg accessor */
      void Cobyla::SpecificParameters::setRhoBeg(const NumericalScalar rhoBeg)
      {
        rhoBeg_ = rhoBeg;
      }

      /* String converter */
      String Cobyla::SpecificParameters::str() const
      {
	OSS oss;
	oss << "class=" << Cobyla::SpecificParameters::GetClassName()
            << " rhoBeg=" << rhoBeg_;
	return oss;
      }

    } /* namespace Optimisation */
  } /* namespace Base */
} /* namespace OpenTURNS */



