//                                               -*- C++ -*-
/**
 *  @file  BoundConstrainedAlgorithmImplementationResult.cxx
 *  @brief Result stores the result of a BoundConstrainedAlgorithmImplementation algorithm
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: BoundConstrainedAlgorithmImplementationResult.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include "BoundConstrainedAlgorithmImplementation.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optimisation
    {

      CLASSNAMEINIT(BoundConstrainedAlgorithmImplementation::Result);

      static Base::Common::Factory<BoundConstrainedAlgorithmImplementation::Result> RegisteredFactory("BoundConstrainedAlgorithmImplementation::Result");

      /* Default constructor */
      BoundConstrainedAlgorithmImplementation::Result::Result():
	PersistentObject(),
        optimizer_(NumericalPoint(1)),
	optimalValue_(0.0),
	optimization_(MINIMIZATION),
        evaluationsNumber_(0),
        absoluteError_(0.),
        relativeError_(0.),
        objectiveError_(0.),
        constraintError_(0.)
      {
	// Nothing to do
      }

      /* Standard constructor */
      BoundConstrainedAlgorithmImplementation::Result::Result(const NumericalPoint & optimizer,
							      const NumericalScalar optimalValue,
							      const OptimizationProblem optimization,
							      const UnsignedLong evaluationsNumber,
			  				      const NumericalScalar absoluteError,
							      const NumericalScalar relativeError,
							      const NumericalScalar objectiveError,
							      const NumericalScalar constraintError):
	PersistentObject(),
        optimizer_(optimizer),
	optimalValue_(optimalValue),
	optimization_(optimization),
        evaluationsNumber_(evaluationsNumber),
        absoluteError_(absoluteError),
        relativeError_(relativeError),
        objectiveError_(objectiveError),
        constraintError_(constraintError)
      {
	// Nothing to do
      }

      /* Virtual constructor */
      BoundConstrainedAlgorithmImplementation::Result * BoundConstrainedAlgorithmImplementation::Result::clone() const
      {
	return new Result(*this);
      }

      /* Optimizer accessors */
      BoundConstrainedAlgorithmImplementation::NumericalPoint BoundConstrainedAlgorithmImplementation::Result::getOptimizer() const
      {
	return optimizer_;
      }

      void BoundConstrainedAlgorithmImplementation::Result::setOptimizer(const NumericalPoint & optimizer)
      {
	optimizer_ = optimizer;
      }

      /* Optimal value accessors */
      NumericalScalar BoundConstrainedAlgorithmImplementation::Result::getOptimalValue() const
      {
	return optimalValue_;
      }

      void BoundConstrainedAlgorithmImplementation::Result::setOptimalValue(const NumericalScalar optimalValue)
      {
	optimalValue_ = optimalValue;
      }

      /* Optimization problem accessors */
      BoundConstrainedAlgorithmImplementation::OptimizationProblem BoundConstrainedAlgorithmImplementation::Result::getOptimizationProblem() const
      {
	return optimization_;
      }

      void BoundConstrainedAlgorithmImplementation::Result::setOptimizationProblem(const OptimizationProblem optimization)
      {
	optimization_ = optimization;
      }

      /* Iterations number accessor */
      UnsignedLong BoundConstrainedAlgorithmImplementation::Result::getEvaluationsNumber() const
      {
	return evaluationsNumber_;
      }

      void BoundConstrainedAlgorithmImplementation::Result::setEvaluationsNumber(const UnsignedLong evaluationsNumber)
      {
	evaluationsNumber_ = evaluationsNumber;
      }

      /* Absolute error accessor */
      NumericalScalar BoundConstrainedAlgorithmImplementation::Result::getAbsoluteError() const
      {
	return absoluteError_;
      }

      void BoundConstrainedAlgorithmImplementation::Result::setAbsoluteError(const NumericalScalar absoluteError)
      {
	absoluteError_ = absoluteError;
      }

      /* Relative error accessor */
      NumericalScalar BoundConstrainedAlgorithmImplementation::Result::getRelativeError() const
      {
	return relativeError_;
      }

      void BoundConstrainedAlgorithmImplementation::Result::setRelativeError(const NumericalScalar relativeError)
      {
	relativeError_ = relativeError;
      }

      /* Objective error accessor */
      NumericalScalar BoundConstrainedAlgorithmImplementation::Result::getObjectiveError() const
      {
	return objectiveError_;
      }

      void BoundConstrainedAlgorithmImplementation::Result::setObjectiveError(const NumericalScalar objectiveError)
      {
	objectiveError_ = objectiveError;
      }

      /* Constraint error accessor */
      NumericalScalar BoundConstrainedAlgorithmImplementation::Result::getConstraintError() const
      {
	return constraintError_;
      }

      void BoundConstrainedAlgorithmImplementation::Result::setConstraintError(const NumericalScalar constraintError)
      {
	constraintError_ = constraintError;
      }

      /* String converter */
      String BoundConstrainedAlgorithmImplementation::Result::str() const
      {
	OSS oss;
	oss << "class=" << BoundConstrainedAlgorithmImplementation::Result::GetClassName()
            << " optimizer=" << optimizer_
            << " optimal value=" << optimalValue_
	    << " optimization problem=" << optimization_
	    << " evaluationsNumber=" << evaluationsNumber_
	    << " absoluteError=" << absoluteError_
	    << " relativeError=" << relativeError_
	    << " objectiveError=" << objectiveError_
	    << " constraintError=" << constraintError_;
	return oss;
      }

      /* Method save() stores the object through the StorageManager */
      void BoundConstrainedAlgorithmImplementation::Result::save(const StorageManager::Advocate & adv) const
      {
	PersistentObject::save(adv);
	adv.writeValue(optimizer_, StorageManager::MemberNameAttribute, "optimizer_");
	adv.writeValue("evaluationsNumber_", evaluationsNumber_);
 	adv.writeValue("absoluteError_", absoluteError_);
 	adv.writeValue("relativeError_", relativeError_);
 	adv.writeValue("objectiveError_", objectiveError_);
 	adv.writeValue("constraintError_", constraintError_);
      }

      /* Method load() reloads the object from the StorageManager */
      void BoundConstrainedAlgorithmImplementation::Result::load(const StorageManager::Advocate & adv)
      {
	PersistentObject::load(adv);
	adv.readValue(optimizer_, StorageManager::MemberNameAttribute, "optimizer_");
	String name;
	UnsignedLong unsignedLongValue;
	StorageManager::List objList = adv.getList(StorageManager::UnsignedLongEntity);
	for(objList.firstValueToRead(); objList.moreValuesToRead(); objList.nextValueToRead()) {
	  if (objList.readValue(name, unsignedLongValue)) {
	    if (name == "evaluationsNumber_") evaluationsNumber_ = unsignedLongValue;
	  }
	}
	NumericalScalar scalarValue;
	objList = adv.getList(StorageManager::NumericalScalarEntity);
	for(objList.firstValueToRead(); objList.moreValuesToRead(); objList.nextValueToRead()) {
	  if (objList.readValue(name, scalarValue)) {
	    if (name == "absoluteError_") absoluteError_ = scalarValue;
	    if (name == "relativeError_") relativeError_ = scalarValue;
	    if (name == "objectiveError_") objectiveError_ = scalarValue;
	    if (name == "constraintError_") constraintError_ = scalarValue;
	  }
	}
      }

    } /* namespace Optimisation */
  } /* namespace Base */
} /* namespace OpenTURNS */
