//                                               -*- C++ -*-
/**
 * @file  NumericalMathEvaluationImplementationFactory.hxx
 * @brief The class NumericalMathEvaluationImplementationFactory creates NumericalMathEvaluationImplementation from external codes
 *
 * (C) Copyright 2005-2006 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * @author $LastChangedBy: dutka $
 * @date   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 */

#ifndef OPENTURNS_NUMERICALMATHFUNCTIONIMPLEMENTATIONFACTORY_HXX
#define OPENTURNS_NUMERICALMATHFUNCTIONIMPLEMENTATIONFACTORY_HXX

#include <iostream>              // for std::ostream
#include "OT.hxx"
#include "Pointer.hxx"
#include "Exception.hxx"
#include "NumericalMathEvaluationImplementation.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      /**
       * @class NumericalMathEvaluationImplementationFactory
       *
       * NumericalMathEvaluationImplementationFactory creates NumericalMathEvaluationImplementation from external codes
       */

      class NumericalMathEvaluationImplementationFactory
	: public Common::Object
      {
	CLASSNAME;
      public:

	/* Some typedefs to ease reading */
	typedef Common::Pointer<NumericalMathEvaluationImplementation> Implementation;
	typedef Common::InvalidArgumentException InvalidArgumentException;

	/** Default constructor */
	NumericalMathEvaluationImplementationFactory();


	/** Implementation creation */
	Implementation buildImplementation(const String & functionName) const
	  throw(InvalidArgumentException);
	  
	/** String converter */
	virtual String str() const;



      protected:

	/* Here is the interface that all derived classes must implement */

	/** Object builder */
	virtual NumericalMathEvaluationImplementation * buildObject(const String & functionName) const = 0;



      private:

      }; /* class NumericalMathEvaluationImplementationFactory */

    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NUMERICALMATHFUNCTIONIMPLEMENTATIONFACTORY_HXX */
