//                                               -*- C++ -*-
/**
 * @file  NumericalMathEvaluationImplementationFactory.cxx
 * @brief The class NumericalMathEvaluationImplementationFactory creates NumericalMathEvaluationImplementation from external codes
 *
 * (C) Copyright 2005-2006 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * @author $LastChangedBy: dutka $
 * @date   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 */

#include "WrapperFile.hxx"
#include "Exception.hxx"
#include "NumericalMathEvaluationImplementationFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      CLASSNAMEINIT(NumericalMathEvaluationImplementationFactory);

      /* Default constructor */
      NumericalMathEvaluationImplementationFactory::NumericalMathEvaluationImplementationFactory()
      {
        // Nothing to do
      }


      /* String converter */
      String NumericalMathEvaluationImplementationFactory::str() const
      {
	OSS oss;
	oss << "class=" << NumericalMathEvaluationImplementationFactory::GetClassName();
	return oss;
      }




      /* Implementation creation */
      NumericalMathEvaluationImplementationFactory::Implementation NumericalMathEvaluationImplementationFactory::buildImplementation(const String & functionName) const
	throw(InvalidArgumentException)
      {
	return Implementation(buildObject(functionName));
      }

    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
