//                                               -*- C++ -*-
/**
 *  @file  NoNumericalMathGradientImplementation.hxx
 *  @brief Abstract top-level class for all numerical math gradient implementations
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: NoNumericalMathGradientImplementation.hxx 995 2008-10-31 10:52:04Z dutka $
 */
#ifndef OPENTURNS_NONUMERICALMATHGRADIENTIMPLEMENTATION_HXX
#define OPENTURNS_NONUMERICALMATHGRADIENTIMPLEMENTATION_HXX

#include "NumericalMathGradientImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class NoNumericalMathGradientImplementation
       *
       * This class offers an interface for an real numerical mathematical gradient
       * implementations into the platform. It realizes the computation of the image vector
       * of a vector (aka NumericalPoint) through the gradient. The
       * gradient may be loaded in an external way through a wrapper.
       */
      class NoNumericalMathGradientImplementation
	: public NumericalMathGradientImplementation
      {
	CLASSNAME;
      public:

	typedef NumericalMathGradientImplementation::Description Description;
	typedef NumericalMathGradientImplementation::NumericalPoint NumericalPoint;
	typedef NumericalMathGradientImplementation::Matrix Matrix;
	typedef NumericalMathGradientImplementation::Tensor Tensor;
	typedef NumericalMathGradientImplementation::InvalidArgumentException InvalidArgumentException;
	typedef NumericalMathGradientImplementation::InternalException InternalException;

	/** Default constructor */
	NoNumericalMathGradientImplementation();

	/** Virtual constructor */
	virtual NoNumericalMathGradientImplementation * clone() const;

	/** Comparison operator */
	Bool operator ==(const NoNumericalMathGradientImplementation & other) const;

	/** String converter */
	virtual String str() const;



	/* Here is the interface that all derived class must implement */
	
	/** Gradient method */
	virtual Matrix gradient(const NumericalPoint & in) const
	  throw(InvalidArgumentException,InternalException);

	/** Accessor for input point dimension */
	virtual UnsignedLong getInputNumericalPointDimension() const
	  throw(InternalException);

	/** Accessor for output point dimension */
	virtual UnsignedLong getOutputNumericalPointDimension() const
	  throw(InternalException);

	/** Test for actual implementation */
	virtual Bool isActualImplementation() const;

 	/** Method save() stores the object through the StorageManager
	 *  The inherited method is sufficient as we do not have any
         *  attribute
         */

	/** Method load() reloads the object from the StorageManager
	 *  The inherited method is sufficient as we do not have any
         *  attribute
         */

      protected:

	/** The gradient that actually realizes assignment between objects */
    
      private:

      }; /* class NoNumericalMathGradientImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NONUMERICALMATHGRADIENTIMPLEMENTATION_HXX */
