//                                               -*- C++ -*-
/**
 * @file  NoNumericalMathEvaluationImplementation.hxx
 * @brief Class for unavailable evaluation implementations
 *
 * (C) Copyright 2005-2006 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: dutka $
 * \date   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 */

#ifndef OPENTURNS_NONUMERICALMATHEVALUATIONIMPLEMENTATION_HXX
#define OPENTURNS_NONUMERICALMATHEVALUATIONIMPLEMENTATION_HXX

#include "NumericalMathEvaluationImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class NoNumericalMathEvaluationImplementation
       *
       * Class for unavailable evaluation implementations
       */
      class NoNumericalMathEvaluationImplementation
	: public NumericalMathEvaluationImplementation
      {
	CLASSNAME;
      public:

	typedef NumericalMathEvaluationImplementation::Description Description;
	typedef NumericalMathEvaluationImplementation::NumericalPoint NumericalPoint;
	typedef NumericalMathEvaluationImplementation::Matrix Matrix;
	typedef NumericalMathEvaluationImplementation::InvalidArgumentException InvalidArgumentException;
	typedef NumericalMathEvaluationImplementation::InternalException InternalException;
	typedef NumericalMathEvaluationImplementation::NumericalSample NumericalSample;


	/** Default constructor */
	NoNumericalMathEvaluationImplementation();

	/** Virtual constructor */
	virtual NoNumericalMathEvaluationImplementation * clone() const;

	/** Comparison operator */
	Bool operator ==(const NoNumericalMathEvaluationImplementation & other) const;

	/** String converter */
	virtual String str() const;


	/** Test for actual implementation */
	virtual Bool isActualImplementation() const;


	/* Here is the interface that all derived class must implement */
	
	/** Operator () */
	virtual NumericalPoint operator() (const NumericalPoint & in) const
	  throw(InvalidArgumentException,InternalException);

	/** Accessor for input point dimension */
	virtual UnsignedLong getInputNumericalPointDimension() const
	  throw(InternalException);

	/** Accessor for output point dimension */
	virtual UnsignedLong getOutputNumericalPointDimension() const
	  throw(InternalException);

 	/** Method save() stores the object through the StorageManager
	 *  The inherited method is sufficient as we do not have any
         *  attribute
         */

	/** Method load() reloads the object from the StorageManager
	 *  The inherited method is sufficient as we do not have any
         *  attribute
         */

      protected:

    
      private:

      }; /* class NoNumericalMathEvaluationImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NONONUMERICALMATHEVALUATIONIMPLEMENTATION_HXX */
