//                                               -*- C++ -*-
/**
 * @file  NoNumericalMathEvaluationImplementation.cxx
 * @brief Class for unavailable evaluation implementations
 *
 * (C) Copyright 2005-2006 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: dutka $
 * \date   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 */

#include "NoNumericalMathEvaluationImplementation.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {

      CLASSNAMEINIT(NoNumericalMathEvaluationImplementation);

      static Common::Factory<NoNumericalMathEvaluationImplementation> RegisteredFactory("NoNumericalMathEvaluationImplementation");

      /* Default constructor */
      NoNumericalMathEvaluationImplementation::NoNumericalMathEvaluationImplementation()
	: NumericalMathEvaluationImplementation()
      {
	// Nothing to do
      }

      /* Virtual constructor */
      NoNumericalMathEvaluationImplementation * NoNumericalMathEvaluationImplementation::clone() const
      {
	return new NoNumericalMathEvaluationImplementation(*this);
      }

      /* Comparison operator */
      Bool NoNumericalMathEvaluationImplementation::operator ==(const NoNumericalMathEvaluationImplementation & other) const
      {
	return true;
      }
  
      /* String converter */
      String NoNumericalMathEvaluationImplementation::str() const {
	OSS oss;
	oss << "class=" << NoNumericalMathEvaluationImplementation::GetClassName()
	    << " name=" << getName();
	return oss;
      }
  
      /* Test for actual implementation */
      Bool NoNumericalMathEvaluationImplementation::isActualImplementation() const
      {
	return false;
      }






      /* Here is the interface that all derived class must implement */
	
      /* Operator () */
      NoNumericalMathEvaluationImplementation::NumericalPoint NoNumericalMathEvaluationImplementation::operator() (const NumericalPoint & in) const
	throw(InvalidArgumentException,InternalException)
      {
	callsNumber_++;
	return NumericalPoint();
      }

      /* Accessor for input point dimension */
      UnsignedLong NoNumericalMathEvaluationImplementation::getInputNumericalPointDimension() const
	throw(InternalException)
      {
	return 0;
      }
      
      /* Accessor for output point dimension */
      UnsignedLong NoNumericalMathEvaluationImplementation::getOutputNumericalPointDimension() const
	throw(InternalException)
      {
	return 0;
      }
      
    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
