//                                               -*- C++ -*-
/**
 * @file  ComputedNumericalMathEvaluationImplementationFactory.hxx
 * @brief The class ComputedNumericalMathEvaluationImplementationFactory creates ComputedNumericalMathEvaluationImplementation from external codes
 *
 * (C) Copyright 2005-2006 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * @author $LastChangedBy: dutka $
 * @date   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 */

#ifndef OPENTURNS_COMPUTEDNUMERICALMATHFUNCTIONIMPLEMENTATIONFACTORY_HXX
#define OPENTURNS_COMPUTEDNUMERICALMATHFUNCTIONIMPLEMENTATIONFACTORY_HXX

#include <iostream>              // for std::ostream
#include "OT.hxx"
#include "Pointer.hxx"
#include "Exception.hxx"
#include "ComputedNumericalMathEvaluationImplementation.hxx"
#include "NumericalMathEvaluationImplementationFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      /**
       * @class ComputedNumericalMathEvaluationImplementationFactory
       *
       * ComputedNumericalMathEvaluationImplementationFactory creates ComputedNumericalMathEvaluationImplementation from external codes
       */

      class ComputedNumericalMathEvaluationImplementationFactory
	: public NumericalMathEvaluationImplementationFactory
      {
	CLASSNAME;
      public:

	/* Some typedefs to ease reading */
	typedef Common::Pointer<ComputedNumericalMathEvaluationImplementationFactory> Instance;
	typedef NumericalMathEvaluationImplementationFactory::Implementation Implementation;
	typedef Common::InvalidArgumentException InvalidArgumentException;

	/** The accessor to the Singleton element */
	static Instance getInstance();



      public:

	/** String converter */
	virtual String str() const;


	/** Object builder */
	virtual NumericalMathEvaluationImplementation * buildObject(const String & functionName) const;


      protected:

      private:

	/** The unique instance of the Singleton model */
	static Instance P_instance_;

	/** Default constructor */
	ComputedNumericalMathEvaluationImplementationFactory();



      }

      ; /* class ComputedNumericalMathEvaluationImplementationFactory */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COMPUTEDNUMERICALMATHFUNCTIONIMPLEMENTATIONFACTORY_HXX */
