//                                               -*- C++ -*-
/**
 *  @file  ComposedNumericalMathHessianImplementation.hxx
 *  @brief The class that implements the composition between numerical math hessians
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: ComposedNumericalMathHessianImplementation.hxx 995 2008-10-31 10:52:04Z dutka $
 */
#ifndef OPENTURNS_COMPOSEDNUMERICALMATHHESSIANIMPLEMENTATION_HXX
#define OPENTURNS_COMPOSEDNUMERICALMATHHESSIANIMPLEMENTATION_HXX

#include "NumericalMathHessianImplementation.hxx"
#include "NumericalMathGradientImplementation.hxx"
#include "NumericalMathEvaluationImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class ComposedNumericalMathHessianImplementation
       *
       * The class that implement the composition of two numerical math hessians
       */
      class ComposedNumericalMathHessianImplementation 
	: public NumericalMathHessianImplementation
      {
	CLASSNAME;
      public:

	/* Some typedefs for easy reading */
	typedef NumericalMathHessianImplementation::NumericalPoint           NumericalPoint;
	typedef Type::Matrix                                                 Matrix;
	typedef NumericalMathHessianImplementation::SymmetricTensor          SymmetricTensor;
	typedef Common::Pointer<NumericalMathHessianImplementation>          HessianImplementation;
	typedef Common::Pointer<NumericalMathGradientImplementation>         GradientImplementation;
	typedef Common::Pointer<NumericalMathEvaluationImplementation>       EvaluationImplementation;
	typedef NumericalMathHessianImplementation::InvalidArgumentException InvalidArgumentException;
	typedef NumericalMathHessianImplementation::InternalException        InternalException;
	typedef NumericalMathHessianImplementation::StorageManager           StorageManager;

	/** Default constructor */
	ComposedNumericalMathHessianImplementation(const GradientImplementation & p_leftGradient,
						   const HessianImplementation & p_leftHessian,
                                                   const EvaluationImplementation & p_rightFunction,
						   const GradientImplementation & p_rightGradient,
                                                   const HessianImplementation & p_rightHessian) throw(InvalidArgumentException);


	/** Virtual constructor */
	virtual ComposedNumericalMathHessianImplementation * clone() const;

	/** Comparison operator */
	Bool operator ==(const ComposedNumericalMathHessianImplementation & other) const;

	/** String converter */
	virtual String str() const;

	/** Method hessian() returns the symetric tensor of the function at point */
	SymmetricTensor hessian(const NumericalPoint & in) const
	  throw(InvalidArgumentException,InternalException);

	/** Accessor for input point dimension */
	UnsignedLong getInputNumericalPointDimension() const
	  throw(InternalException);

	/** Accessor for output point dimension */
	UnsignedLong getOutputNumericalPointDimension() const
	  throw(InternalException);

 	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(const StorageManager::Advocate & adv);

      protected:

	ComposedNumericalMathHessianImplementation() {};
	friend class Common::Factory<ComposedNumericalMathHessianImplementation>;
      private:

	/** The gradient of f in h = f o g */
	GradientImplementation p_leftGradient_;

	/** The hessian of f in h = f o g */
	HessianImplementation p_leftHessian_;

	/** The function g in h = f o g */
	EvaluationImplementation p_rightFunction_;

	/** The gradient of g in h = f o g */
	GradientImplementation p_rightGradient_;

	/** The hessian of g in h = f o g */
        HessianImplementation p_rightHessian_;

      }; /* class ComposedNumericalMathHessianImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COMPOSEDNUMERICALMATHHESSIANIMPLEMENTATION_HXX */
