//                                               -*- C++ -*-
/**
 *  @file  Thread.hxx
 *  @brief The class Thread realizes multithreading implementation
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-10 16:43:31 +0200 (jeu 10 mai 2007) $
 *  Id:      $Id: Thread.hxx 434 2007-05-10 14:43:31Z dutka $
 */
#ifndef OPENTURNS_THREAD_HXX
#define OPENTURNS_THREAD_HXX

#include "OT.hxx"
#include "Threadable.hxx"
#include "ThreadStatus.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /**
       * @class Thread
       *
       * Class Thread implements the multithreading mechanims for
       * the Open TURNS platform. It ensures concurrency and 
       * parallelism between Threadable objects. However the
       * responsibility of shared data protection is devoted to
       * each Threadable objects. Thread class does NOT provide
       * any help in protecting those shared data from race condition
       * or any other parallel issue.
       *
       * @note This class is NOT intended to be derived. So DO NOT try
       * to do it.
       */

      class Thread
      {
	CLASSNAME;
      public:

	/** 
	 * Default constructor
	 */
	explicit Thread(const Threadable & th);

	/** Destructor */
	virtual ~Thread();

	/** Comparison operator */
	Bool operator ==(const Thread & other) const;

	/**
	 * String converter
	 * This method shows human readable information on the
	 * internal state of a thread. It is used when streaming
	 * the thread or for user information.
	 */
	String str() const;

	/**
	 * Start running the Threadable object
	 */
	void start() const;

	/**
	 * Cancel execution of the Threadable object
	 * Because cancellation is not abortion, it is up to the
	 * Threadable to accept cancellation. So calling this method
	 * does not mean that the Thread will actually stop
	 */
	void cancel() const;

	/**
	 * Get a ThreadStatus object that informs the user of
	 * the internal status of the current thread
	 */
	const ThreadStatus getStatus() const;

      protected:

      private:

	/** The Threadable object this thread must run */
	const Threadable & threadable_;

	/** Copy constructor */
	Thread(const Thread & other);

	/** Assignment */
	Thread & operator =(const Thread & other);

      }

      ; /* class Thread */


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_THREAD_HXX */
