//                                               -*- C++ -*-
/**
 *  @file  Log.hxx
 *  @brief Log records all user information to a file or tty
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-29 18:54:45 +0100 (mer 29 oct 2008) $
 *  Id:      $Id: Log.hxx 990 2008-10-29 17:54:45Z dutka $
 */
#ifndef OPENTURNS_LOG_HXX
#define OPENTURNS_LOG_HXX

#include <fstream>
#include <map>
#include "OT.hxx"
#include "OTconfig.hxx"


namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {


      /**
       * Log records all user information to a file or tty
       */

      class Log
      {
      public:

	typedef unsigned long Severity;

	/** Those flags should be ORed */
	static const Severity DBG;
	static const Severity WRAPPER;
	static const Severity INFO;
	static const Severity USER;
	static const Severity WARN;
	static const Severity ERROR;

	static const Severity NONE;
	static const Severity ALL;

	// Log messages according to its relative severity
	static void Debug(const String & msg);
	static void Wrapper(const String & msg);
	static void Info(const String & msg);
	static void User(const String & msg);
	static void Warn(const String & msg);
	static void Error(const String & msg);

	static void SetFile(const FileName & file);

	/* Get/Set the severity flags for the messages logged to the file */
	static void Show(Severity flags);
	static Severity Flags();


      private:
	static Log & GetInstance();
	static void Release();

      private:
	/** The unique instance of the Singleton */
	static Log * P_instance_;

	/** Minimum severity logged to the file */
	static Severity Severity_;

      public:
#ifndef SWIG	
	struct Entry
	{
	  Severity sev_;
	  String msg_;
	  Entry(Severity sev, String msg) : sev_(sev), msg_(msg) {}
	}; /* end struct Entry */
#endif
	~Log();

      private:
	Log();
	void push(const Entry & entry);

	/** Set the name of the log file */
	void setFile(const FileName & file);

      private:
	/** The file where to write messages */
	std::ostream * p_file_;

	std::map<Severity, String> prefix_;

      }; /* end class Log */






    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LOG_HXX */
