//                                               -*- C++ -*-
/**
 *  @file  Lockable.hxx
 *  @brief The class Lockable defines an interface for the lock functionality
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-07-17 09:59:07 +0200 (jeu 17 jui 2008) $
 *  Id:      $Id: Lockable.hxx 884 2008-07-17 07:59:07Z dutka $
 */
#ifndef OPENTURNS_LOCKABLE_HXX
#define OPENTURNS_LOCKABLE_HXX

#include "OT.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /**
       * @class Lockable
       *
       * Lockable is an interface (an abstract class) intended to
       * be derived by any class that need to be run in a multithreaded
       * environment. It provides a lock mechanism that protect the object
       * from being concurrently accessed and then being corrupted.
       * The embedded Lock class is a scoped-lock, ie the lock is 
       * guaranted during the lifetime of the Lock object.
       */
      class Lockable
      {
      public:



	/**
	 * @class Lock
	 *
	 * This class provides a mechanism of scoped lock.
	 */
	class Lock
	{
	public:

	  /**
	   * Usual constructor 
	   * Take the mutex of the Lockable Object
	   */
	  Lock(const Lockable * p_lockableObject);

	  /**
	   * Constructor with another mutex
	   */
	  //Lock(pthread_mutex_t & mutex);

	  /** 
	   * Destructor
	   * Release the mutex of the Lockable Object
	   */
	  virtual ~Lock();

	protected:

	private:
	  /** A pointer to the mutex to lock/unlock */
	  //pthread_mutex_t * p_mutex_;

	}; /* class Lock */




	friend class Lock;

	/**
	 * Default constructor
	 * Initialize the mutex
	 */
	Lockable();

	/**
	 * Copy constructor
	 * Initialize the mutex
	 */
	Lockable(const Lockable & other);

	/**
	 * Destructor
	 * Destroy the mutex
	 */
	virtual ~Lockable();

      protected:
	/** The mutex that protect the object */
	//mutable pthread_mutex_t mutex_;

      private:


      }; /* class Lockable */


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LOCKABLE_HXX */
