//                                               -*- C++ -*-
/**
 *  @file  Less.hxx
 *  @brief Abstract top-level class for all Less
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: Less.hxx 995 2008-10-31 10:52:04Z dutka $
 */
#ifndef OPENTURNS_LESS_HXX
#define OPENTURNS_LESS_HXX

#include "ComparisonOperatorImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Common {


      /**
       * @class Less
       *
       * The class describes the probabilistic concept of Less.
       */
      class Less 
	: public ComparisonOperatorImplementation
      {
	CLASSNAME;
      public:

	/** Default constructor */
	explicit Less();

	/* String converter */
	String str() const;


	/* Here is the interface that all derived class must implement */

	/** Virtual constructor */
	virtual Less * clone() const;

	/** Return true if comparison succeeds */
	virtual Bool operator() (NumericalScalar a, NumericalScalar b) const;

	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(const StorageManager::Advocate & adv);

      }; /* class Less */


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LESS_HXX */
