//                                               -*- C++ -*-
/**
 *  @file  InterfaceObject.hxx
 *  @brief The abstract class InterfaceObject defines the GetImplementation method
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: InterfaceObject.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_INTERFACEOBJECT_HXX
#define OPENTURNS_INTERFACEOBJECT_HXX

#include "OT.hxx"
#include "Pointer.hxx"
#include "Object.hxx"
#include "PersistentObject.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /**
       * @class InterfaceObject
       *
       * InterfaceObject defines a pure virtual method getImplementation
       * that returns a pointer to a PersistentObject.
       */

      class InterfaceObject
	: public Object
      {
	CLASSNAME;
      public:

	typedef Pointer<PersistentObject>   ImplementationAsPersistentObject;

	/** Destructor */
	virtual ~InterfaceObject();

	/** String converter */
	virtual String str() const;

	/** Returns a pointer to the underlying implementation object viewed as a PersistentObject */
	virtual ImplementationAsPersistentObject getImplementationAsPersistentObject() const = 0 ;

	/** Sets the pointer to the underlying implementation object */
	virtual void setImplementationAsPersistentObject(const ImplementationAsPersistentObject & obj) = 0;

	/** Id accessor */
	Id getId() const;

	/** Name accessor */
	virtual void setName(const String & name);
	virtual String getName() const;

	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager & mgr) const;

      }; /* class InterfaceObject */


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_INTERFACEOBJECT_HXX */
