//                                               -*- C++ -*-
/**
 *  @file  InterfaceObject.cxx
 *  @brief The abstract class InterfaceObject defines the GetImplementation method
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: InterfaceObject.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>              // for std::ostream
#include "InterfaceObject.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      CLASSNAMEINIT(InterfaceObject);

      /* Destructor */
      InterfaceObject::~InterfaceObject()
      {}

      
      /* String converter */
      String InterfaceObject::str() const
      {
	return getImplementationAsPersistentObject()->str();
      }

      /* Id accessor */
      Id InterfaceObject::getId() const
      {
	return getImplementationAsPersistentObject()->getId();
      }

      /* Name accessor */
      void InterfaceObject::setName(const String & name)
      {
	getImplementationAsPersistentObject()->setName(name);
      }


      /* Name accessor */
      String InterfaceObject::getName() const
      {
	return getImplementationAsPersistentObject()->getName();
      }


      /* Method save() stores the object through the StorageManager */
      void InterfaceObject::save(const StorageManager & mgr) const
      {
	getImplementationAsPersistentObject()->save(mgr);
      }


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
