//                                               -*- C++ -*-
/**
 *  @file  Exception.hxx
 *  @brief Exception defines top-most exception strategies
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-10 16:43:31 +0200 (jeu 10 mai 2007) $
 *  Id:      $Id: Exception.hxx 434 2007-05-10 14:43:31Z dutka $
 */
#ifndef OPENTURNS_EXCEPTION_HXX
#define OPENTURNS_EXCEPTION_HXX

#include <vector>
#include "ExceptionDefs.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {


      /**
       * ExceptionNames defines the name of all exceptions.
       * It also check the bounds of the vector so that
       * wrong exception declaration should be detected
       * (at run-time).
       */

      class ExceptionNames
      {
      public:
	static const String get(unsigned int id);
	static void release();
	~ExceptionNames();

      private:
	static ExceptionNames * p_instance;

      private:
	ExceptionNames();

	std::vector<String> names_;
      }
      ; /* end class ExceptionNames */




      /**
       *
       * All exceptions defined for the user are listed below
       *
       */



      typedef UserException<0>                    FileNotFoundException;
      typedef UserException<1>                    InternalException;
      typedef UserException<2>                    InvalidArgumentException;
      typedef UserException<3>                    InvalidDimensionException;
      typedef UserException<4>                    NoWrapperFileFoundException;
      typedef UserException<5>                    NotYetImplementedException;
      typedef UserException<6>                    OutOfBoundException;
      typedef UserException<7>                    WrapperFileParsingException;
      typedef UserException<8,InternalException>  WrapperInternalException;
      typedef UserException<9>                    XMLException;
      typedef UserException<10>                   XMLParserException;
      typedef UserException<11>                   DynamicLibraryException;
      // For quadratic cumul
      typedef UserException<12>                   NotSymmetricDefinitePositiveException;
      // For strong maximum test
      typedef UserException<13>                   InvalidRangeException;
      // For distribution
      typedef UserException<14>                   NotDefinedException;
      // For ROT
      typedef UserException<15>			  NetworkException;
      typedef UserException<16>			  RException;
      typedef UserException<17>			  FileOpenException;
      typedef UserException<18>			  StudyFileParsingException;
      typedef UserException<19>			  ObjectNotInStudyException;
      typedef UserException<20>			  ConfigurationFileParsingException;






    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_EXCEPTION_HXX */
