#                                               -*- Autoconf -*-
#
#  ot_check_qt.m4
#
#  (C) Copyright 2005-2007 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: dutka $
#  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (Thu, 26 Jun 2008) $
#  Id:      $Id: ot_check_qt.m4 862 2008-06-26 11:50:17Z dutka $
#
#
#  This file is intended to be include in the configure.in file
#  of Open TURNS project to check whether Python is available on the
#  build platform.
#
# OT_CHECK_QT
# -----------
#
AC_DEFUN([OT_CHECK_QT],
[
  BNV_HAVE_QT
  AC_LANG_PUSH([C++])

  saved_CPPFLAGS=$CPPFLAGS
  #saved_CXXFLAGS=$CXXFLAGS
  CPPFLAGS=$QT_CXXFLAGS
  #CXXFLAGS=$QT_CXXFLAGS

  AC_CHECK_HEADER([qfile.h], [qt_qfile_header_file_found=yes], [qt_qfile_header_file_found=no])
  test $qt_qfile_header_file_found = yes || AC_MSG_ERROR([QT header file NOT found.])
  AC_CHECK_HEADER([qtextstream.h], [qt_qtextstream_header_file_found=yes], [qt_qtextstream_header_file_found=no])
  test $qt_qtextstream_header_file_found = yes || AC_MSG_ERROR([QT header file NOT found.])
  AC_CHECK_HEADER([qdom.h], [qt_qdom_header_file_found=yes], [qt_qdom_header_file_found=no])
  test $qt_qdom_header_file_found = yes || AC_MSG_ERROR([QT header file NOT found.])

  CPPFLAGS=$saved_CPPFLAGS
  #CXXFLAGS=$saved_CXXFLAGS

  AM_CONDITIONAL(WITH_QT, test "$have_qt" = yes)
  AC_LANG_POP([C++])
])
