#                                               -*- Autoconf -*-
#
#  ot_check_boost.m4
#
#  (C) Copyright 2005-2007 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: dutka $
#  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (Thu, 26 Jun 2008) $
#  Id:      $Id: ot_check_boost.m4 862 2008-06-26 11:50:17Z dutka $
#
#
#  This file is intended to be include in the configure.in file
#  of Open TURNS project to check if BOOST template library is available
#
# OT_CHECK_BOOST
# --------------
#
AC_DEFUN([OT_CHECK_BOOST],
[
  AC_LANG_PUSH([C++])

  WITH_BOOST=0

  saved_CPPFLAGS=$CPPFLAGS

  #BOOST_CPPFLAGS="-DBOOST_SP_USE_PTHREADS"
  BOOST_CPPFLAGS=
  CPPFLAGS="$CPPFLAGS $BOOST_CPPFLAGS"
  AC_CHECK_HEADER([boost/shared_ptr.hpp], [boost_shared_ptr_header_file_found=yes], [boost_shared_ptr_header_file_found=no])
  test $boost_shared_ptr_header_file_found = yes || AC_MSG_ERROR([BOOST header file NOT found.])

  WITH_BOOST=1

  CPPFLAGS=$saved_CPPFLAGS

  AC_LANG_POP([C++])

  AC_SUBST(BOOST_CPPFLAGS)
  AM_CONDITIONAL(WITH_BOOST, test $WITH_BOOST = 1)
])
