//                                               -*- C -*-
/**
 *  @file  OTdebug.h
 *  @brief The header file of Open TURNS for debug level
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-29 18:54:45 +0100 (mer 29 oct 2008) $
 *  Id:      $Id: OTdebug.h 990 2008-10-29 17:54:45Z dutka $
 */
#ifndef OPENTURNS_OTDEBUG_H
#define OPENTURNS_OTDEBUG_H

#ifdef __GNUC__
#define GCC_VERSION (__GNUC__ * 10000		      \
		     + __GNUC_MINOR__ * 100	      \
		     + __GNUC_PATCHLEVEL__)

#if GCC_VERSION <= 30406 /* GCC 3.4.6 and below */
#define REINTERPRET_CAST(T,V) ( (T) (V) )
#else /* GCC after 3.4.6 */
#define REINTERPRET_CAST(T,V) ( reinterpret_cast< T > (V) )
#endif

#define DEPRECATED  __attribute__ ((deprecated))
#define UNUSED      __attribute__ ((unused))

#else
#define GCC_VERSION 0
#define DEPRECATED
#define UNUSED

#endif


/** Define debug levels identifiers */
#ifndef OT_DEBUG_LEVEL
#define OT_DEBUG_LEVEL 0
#endif

#if (OT_DEBUG_LEVEL >= 1)
#define DEBUG
#define DEBUG_1
#if (OT_DEBUG_LEVEL >= 2)
#define DEBUG_2
#if (OT_DEBUG_LEVEL >= 3)
#define DEBUG_3
#if (OT_DEBUG_LEVEL >= 4)
#define DEBUG_4
#if (OT_DEBUG_LEVEL >= 5)
#define DEBUG_5
#if (OT_DEBUG_LEVEL >= 6)
#define DEBUG_6
#if (OT_DEBUG_LEVEL >= 7)
#define DEBUG_7
#if (OT_DEBUG_LEVEL >= 8)
#define DEBUG_8
#if (OT_DEBUG_LEVEL >= 9)
#define DEBUG_9
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif



#endif /* OPENTURNS_OTDEBUG_H */
