//                                               -*- C++ -*-
/**
 * @file		YesNoProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-14 11:45:44
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "YesNoProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			YesNoProperty::YesNoProperty ( QObject* parent, const char* name ) : QOTProperty ( QOTProperty::MultipleChoice, parent, name )
			{
				value_ = "";
			}


			YesNoProperty::~YesNoProperty()
			{}


			QString YesNoProperty::getValue()
			{
				return value_;
			}

			QStringList YesNoProperty::getChoices()
			{
				QStringList choices;
				choices << "yes" << "no";
				return choices;
			}

			bool YesNoProperty::setValue ( QString value )
			{
				if ( value != value_ )
				{
					if ( value == tr ( "yes" ) )
					{
						value_ = "yes";
					}
					else if ( value == tr ( "no" ) )
					{
						value_ = "no";
					}
					emit ( updated() );
					return true;
				}
				return false;
			}

			void YesNoProperty::setDefaultChoice()
			{
				QOTProperty::setDefaultChoice();
			}

		}

	}

}
