//                                               -*- C++ -*-
/**
 * @file		ThresholdExceedanceMethodProperty.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-14 11:42:04
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_UI_GUITHRESHOLDEXCEEDANCEMETHODPROPERTY_HXX
#define OPENTURNS_UI_GUITHRESHOLDEXCEEDANCEMETHODPROPERTY_HXX

// OT::UI::GUI
#include "QOTProperty.hxx"
#include "NumericalScalarProperty.hxx"
#include "UnsignedLongProperty.hxx"
#include "NearestPointAlgorithmProperty.hxx"
#include "StrongMaximumTestProperty.hxx"

// OT
#include "NearestPointAlgorithm.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			typedef OT::Base::Optimisation::NearestPointAlgorithm NearestPointAlgorithm;

			class ThresholdExceedanceMethodProperty : public QOTProperty
			{
					Q_OBJECT
				public:
					ThresholdExceedanceMethodProperty ( QObject *parent, const char *name );

					~ThresholdExceedanceMethodProperty();

					virtual QString getValue();
					virtual QStringList getChoices();
					virtual bool setValue ( QString value );

					QString getMethod() const;
					UnsignedLong getShootCount() const;
					NumericalScalar getPrecision() const;

					NearestPointAlgorithm getNearestPointAlgorithm() const;

					StrongMaximumTestProperty* getStrongMaximumTextProperty();
				public slots:
					void propertyUpdated ( QOTProperty* subproperty );

				protected:
					void createSimulationProperties();
					void createOptimizationProperties();

				protected:
					QString method_;

					UnsignedLong shootCount_;
					UnsignedLong calculationTime_;
					NumericalScalar precision_;

					NearestPointAlgorithm nearestPointAlgorithm_;
					NearestPointAlgorithmProperty* nearestPointAlgorithmProperty_;

					StrongMaximumTestProperty* strongMaximumTestProperty_;
			};

		}

	}

}

#endif
